/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IMonitoringComponentFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.gui.SGUI;
import jadex.commons.gui.future.SwingExceptionDelegationResultListener;
import jadex.commons.transformation.annotations.Classname;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.mandelbrot.ColorChooserPanel;
import jadex.micro.examples.mandelbrot.DisplayPanel;
import jadex.micro.examples.mandelbrot.DisplayService;
import jadex.micro.examples.mandelbrot.IDisplayService;
import jadex.micro.examples.mandelbrot.IGenerateService;
import jadex.micro.examples.mandelbrot.IMandelbrotService;
import jadex.micro.examples.mandelbrot.IProgressService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;

@Description(value="Agent offering a display service.")
@ProvidedServices(value={@ProvidedService(type=IDisplayService.class, implementation=@Implementation(value=DisplayService.class))})
@RequiredServices(value={@RequiredService(name="generateservice", type=IGenerateService.class), @RequiredService(name="progressservice", type=IProgressService.class), @RequiredService(name="cmsservice", type=IComponentManagementService.class, binding=@Binding(scope="platform")), @RequiredService(name="mandelservice", type=IMandelbrotService.class)})
@Agent
public class DisplayAgent {
    @Agent
    protected IInternalAccess agent;
    protected DisplayPanel panel;

    @AgentCreated
    public IFuture<Void> agentCreated() {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("mandelservice");
        fut.addResultListener((IResultListener)new SwingExceptionDelegationResultListener<IMandelbrotService, Void>(ret){

            public void customResultAvailable(IMandelbrotService result) {
                DisplayAgent.this.panel = new DisplayPanel(DisplayAgent.this.agent.getExternalAccess(), result);
                final IExternalAccess access = DisplayAgent.this.agent.getExternalAccess();
                final JFrame frame = new JFrame(DisplayAgent.this.agent.getComponentIdentifier().getName());
                JScrollPane scroll = new JScrollPane(DisplayAgent.this.panel);
                JTextPane helptext = new JTextPane();
                helptext.setText("Use mouse to navigate:\n[wheel] zoom in/out\n[left button] choose and click into area\n[rigth button] drag to move, click for original area.\n");
                helptext.setEditable(false);
                JPanel right = new JPanel(new BorderLayout());
                right.add((Component)new ColorChooserPanel(DisplayAgent.this.panel), "Center");
                right.add((Component)helptext, "North");
                JSplitPane split = new JSplitPane(1, scroll, right);
                split.setResizeWeight(1.0);
                split.setOneTouchExpandable(true);
                split.setDividerLocation(375);
                frame.getContentPane().add("Center", split);
                frame.setSize(500, 400);
                frame.setLocation(SGUI.calculateMiddlePosition((Window)frame));
                frame.setVisible(true);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        access.killComponent();
                    }
                });
                access.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    @Classname(value="dispose")
                    public IFuture<Void> execute(IInternalAccess ia) {
                        ((IMonitoringComponentFeature)ia.getComponentFeature(IMonitoringComponentFeature.class)).subscribeToEvents(IMonitoringEvent.TERMINATION_FILTER, false, IMonitoringService.PublishEventLevel.COARSE).addResultListener((IResultListener)new IntermediateDefaultResultListener<IMonitoringEvent>(){

                            public void intermediateResultAvailable(IMonitoringEvent result) {
                                frame.dispose();
                            }
                        });
                        return IFuture.DONE;
                    }
                });
                ret.setResult(null);
            }
        });
        return ret;
    }

    public DisplayPanel getPanel() {
        return this.panel;
    }
}

