/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IInternalAccess;
import jadex.bridge.SFuture;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.commons.future.IFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.DisplayAgent;
import jadex.micro.examples.mandelbrot.IDisplayService;
import jadex.micro.examples.mandelbrot.ProgressData;
import java.util.HashMap;
import java.util.Map;

@Service
public class DisplayService
implements IDisplayService {
    @ServiceComponent
    protected DisplayAgent agent;
    protected Map<String, SubscriptionIntermediateFuture<Object>> subscribers = new HashMap<String, SubscriptionIntermediateFuture<Object>>();

    @Override
    public IFuture<Void> displayResult(AreaData result) {
        String id = result.getDisplayId();
        if (id != null) {
            SubscriptionIntermediateFuture<Object> sub = this.subscribers.get(id);
            sub.addIntermediateResult((Object)result);
        } else {
            for (SubscriptionIntermediateFuture<Object> sub : this.subscribers.values()) {
                sub.addIntermediateResult((Object)result);
            }
        }
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> displayIntermediateResult(ProgressData progress) {
        String id = progress.getDisplayId();
        if (id != null) {
            SubscriptionIntermediateFuture<Object> sub = this.subscribers.get(id);
            sub.addIntermediateResult((Object)progress);
        } else {
            for (SubscriptionIntermediateFuture<Object> sub : this.subscribers.values()) {
                sub.addIntermediateResult((Object)progress);
            }
        }
        return IFuture.DONE;
    }

    @Override
    public ISubscriptionIntermediateFuture<Object> subscribeToDisplayUpdates(String displayid) {
        SubscriptionIntermediateFuture ret = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IInternalAccess)this.agent.agent);
        this.subscribers.put(displayid, (SubscriptionIntermediateFuture<Object>)ret);
        return ret;
    }
}

