/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.base.gui.StatusBar;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.PropertiesPanel;
import jadex.commons.gui.SGUI;
import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.GenerateService;
import jadex.micro.examples.mandelbrot.IDisplayService;
import jadex.micro.examples.mandelbrot.IFractalAlgorithm;
import jadex.micro.examples.mandelbrot.IGenerateService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class GeneratePanel
extends JPanel {
    protected StatusBar sb;
    protected PropertiesPanel pp;

    public GeneratePanel(final IExternalAccess agent) {
        this.setLayout(new BorderLayout());
        this.pp = new PropertiesPanel("Generate Options");
        final JComboBox<IFractalAlgorithm> alg = new JComboBox<IFractalAlgorithm>(GenerateService.ALGORITHMS);
        alg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeneratePanel.this.updateProperties(((IFractalAlgorithm)alg.getSelectedItem()).getDefaultSettings());
            }
        });
        this.pp.addComponent("algorithm", alg, 0.0);
        AreaData data = GenerateService.ALGORITHMS[0].getDefaultSettings();
        this.pp.createTextField("xmin", "" + data.getXStart(), true, 0.0);
        this.pp.createTextField("xmax", "" + data.getXEnd(), true, 0.0);
        this.pp.createTextField("ymin", "" + data.getYStart(), true, 0.0);
        this.pp.createTextField("ymax", "" + data.getYEnd(), true, 0.0);
        this.pp.createTextField("sizex", "" + data.getSizeX(), true, 0.0);
        this.pp.createTextField("sizey", "" + data.getSizeY(), true, 0.0);
        this.pp.createTextField("max", "" + data.getMax(), true, 0.0);
        this.pp.createTextField("parallel", "" + data.getParallel(), true, 0.0);
        this.pp.createTextField("task size", "" + data.getTaskSize(), true, 0.0);
        JButton[] buts = this.pp.createButtons("buts", new String[]{"Go"}, 0.0);
        buts[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    final IFractalAlgorithm algorithm = (IFractalAlgorithm)((JComboBox)GeneratePanel.this.pp.getComponent("algorithm")).getSelectedItem();
                    final double x1 = Double.parseDouble(GeneratePanel.this.pp.getTextField("xmin").getText());
                    final double x2 = Double.parseDouble(GeneratePanel.this.pp.getTextField("xmax").getText());
                    final double y1 = Double.parseDouble(GeneratePanel.this.pp.getTextField("ymin").getText());
                    final double y2 = Double.parseDouble(GeneratePanel.this.pp.getTextField("ymax").getText());
                    final int sizex = Integer.parseInt(GeneratePanel.this.pp.getTextField("sizex").getText());
                    final int sizey = Integer.parseInt(GeneratePanel.this.pp.getTextField("sizey").getText());
                    final short max = Short.parseShort(GeneratePanel.this.pp.getTextField("max").getText());
                    final int par = Integer.parseInt(GeneratePanel.this.pp.getTextField("parallel").getText());
                    final int tasksize = Integer.parseInt(GeneratePanel.this.pp.getTextField("task size").getText());
                    agent.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                        public IFuture<Void> execute(final IInternalAccess ia) {
                            ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("generateservice").addResultListener((IResultListener)new DefaultResultListener(){

                                public void resultAvailable(Object result) {
                                    IGenerateService gs = (IGenerateService)result;
                                    AreaData ad = new AreaData(x1, x2, y1, y2, sizex, sizey, max, par, tasksize, algorithm, null);
                                    gs.generateArea(ad).addResultListener((IResultListener)new DefaultResultListener(){

                                        public void resultAvailable(Object result) {
                                            final AreaData res = (AreaData)result;
                                            ((IRequiredServicesFeature)ia.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("displayservice").addResultListener((IResultListener)new DefaultResultListener(){

                                                public void resultAvailable(Object result) {
                                                    IDisplayService ds = (IDisplayService)result;
                                                    ds.displayResult(res).addResultListener((IResultListener)new DefaultResultListener(){

                                                        public void resultAvailable(Object result) {
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    });
                                }
                            });
                            return IFuture.DONE;
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.sb = new StatusBar();
        this.add((Component)this.pp, "Center");
        this.add((Component)this.sb, "South");
    }

    public StatusBar getStatusBar() {
        return this.sb;
    }

    public void updateProperties(AreaData data) {
        if (!((JComboBox)this.pp.getComponent("algorithm")).getSelectedItem().equals(data.getAlgorithm())) {
            ((JComboBox)this.pp.getComponent("algorithm")).setSelectedItem(data.getAlgorithm());
        }
        this.pp.getTextField("xmin").setText(Double.toString(data.getXStart()));
        this.pp.getTextField("xmax").setText(Double.toString(data.getXEnd()));
        this.pp.getTextField("ymin").setText(Double.toString(data.getYStart()));
        this.pp.getTextField("ymax").setText(Double.toString(data.getYEnd()));
        this.pp.getTextField("sizex").setText(Integer.toString(data.getSizeX()));
        this.pp.getTextField("sizey").setText(Integer.toString(data.getSizeY()));
        this.pp.getTextField("max").setText(Integer.toString(data.getMax()));
        this.pp.getTextField("parallel").setText(Integer.toString(data.getParallel()));
        this.pp.getTextField("task size").setText(Integer.toString(data.getTaskSize()));
    }

    public static GeneratePanel createGui(final IExternalAccess agent) {
        JFrame f = new JFrame();
        GeneratePanel gp = new GeneratePanel(agent);
        f.add(gp);
        f.pack();
        f.setLocation(SGUI.calculateMiddlePosition((Window)f));
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                agent.killComponent();
            }
        });
        return gp;
    }
}

