/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.IService;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceShutdown;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SUtil;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.gui.SGUI;
import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.GeneratePanel;
import jadex.micro.examples.mandelbrot.ICalculateService;
import jadex.micro.examples.mandelbrot.IDisplayService;
import jadex.micro.examples.mandelbrot.IFractalAlgorithm;
import jadex.micro.examples.mandelbrot.IGenerateService;
import jadex.micro.examples.mandelbrot.IServicePoolHandler;
import jadex.micro.examples.mandelbrot.LyapunovAlgorithm;
import jadex.micro.examples.mandelbrot.MandelbrotAlgorithm;
import jadex.micro.examples.mandelbrot.ProgressData;
import jadex.micro.examples.mandelbrot.ServicePoolManager;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;

@Service
public class GenerateService
implements IGenerateService {
    public static IFractalAlgorithm[] ALGORITHMS = new IFractalAlgorithm[]{new MandelbrotAlgorithm(), new LyapunovAlgorithm()};
    @ServiceComponent
    protected IInternalAccess agent;
    protected GeneratePanel panel;
    protected ServicePoolManager manager;

    @ServiceStart
    public void start() {
        this.panel = GeneratePanel.createGui(this.agent.getExternalAccess());
        this.manager = new ServicePoolManager(this.agent, "calculateservices", new IServicePoolHandler(){

            @Override
            public boolean selectService(IService service) {
                return true;
            }

            @Override
            public IFuture invokeService(final IService service, Object task, Object user) {
                final Future ret = new Future();
                final AreaData ad = (AreaData)task;
                final AreaData data = (AreaData)user;
                ad.setCalculatorId(service.getServiceIdentifier().getProviderId());
                ((IRequiredServicesFeature)GenerateService.this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("displayservice").addResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        final IDisplayService ds = (IDisplayService)result;
                        final ProgressData pd = new ProgressData(ad.getCalculatorId(), ad.getId(), new Rectangle(ad.getXOffset(), ad.getYOffset(), ad.getSizeX(), ad.getSizeY()), false, data.getSizeX(), data.getSizeY(), ad.getDisplayId());
                        ds.displayIntermediateResult(pd).addResultListener((IResultListener)new DefaultResultListener(){

                            public void resultAvailable(Object result) {
                                ((ICalculateService)service).calculateArea(ad).addResultListener((IResultListener)new DelegationResultListener(ret){

                                    public void customResultAvailable(final Object calcresult) {
                                        pd.setFinished(true);
                                        ds.displayIntermediateResult(pd).addResultListener(new IResultListener(){

                                            public void resultAvailable(Object result) {
                                                ret.setResult(calcresult);
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                ret.setResult(calcresult);
                                            }
                                        });
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        super.exceptionOccurred(exception);
                                    }
                                });
                            }

                            public void exceptionOccurred(Exception exception) {
                                ((ICalculateService)service).calculateArea(ad).addResultListener((IResultListener)new DelegationResultListener(ret));
                            }
                        });
                    }

                    public void exceptionOccurred(Exception exception) {
                        ((ICalculateService)service).calculateArea(ad).addResultListener((IResultListener)new DelegationResultListener(ret));
                    }
                });
                return ret;
            }

            @Override
            public IFuture createService() {
                final Future ret = new Future();
                ((IRequiredServicesFeature)GenerateService.this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cmsservice").addResultListener((IResultListener)new DelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        final IComponentManagementService cms = (IComponentManagementService)result;
                        Object delay = ((IArgumentsResultsFeature)GenerateService.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("delay");
                        if (delay == null) {
                            delay = 5000L;
                        }
                        cms.createComponent(null, "jadex/micro/examples/mandelbrot/CalculateAgent.class", new CreationInfo(SUtil.createHashMap((Object[])new String[]{"delay"}, (Object[])new Object[]{delay}), GenerateService.this.agent.getComponentIdentifier().getParent()), null).addResultListener(((IExecutionFeature)GenerateService.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                            public void customResultAvailable(Object result) {
                                cms.getExternalAccess((IComponentIdentifier)result).addResultListener(((IExecutionFeature)GenerateService.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                                    public void customResultAvailable(Object result) {
                                        SServiceProvider.getService((IExternalAccess)((IExternalAccess)result), ICalculateService.class, (String)"local").addResultListener(((IExecutionFeature)GenerateService.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                                            public void customResultAvailable(Object result) {
                                                ret.setResult(result);
                                            }
                                        }));
                                    }
                                }));
                            }
                        }));
                    }
                });
                return ret;
            }
        }, -1);
    }

    @ServiceShutdown
    public IFuture<Void> shutdown() {
        final Future ret = new Future();
        if (this.panel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SGUI.getWindowParent((Component)GenerateService.this.panel).dispose();
                    ret.setResult(null);
                }
            });
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    @Override
    public IFuture<AreaData> generateArea(final AreaData data) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GenerateService.this.panel.updateProperties(data);
            }
        });
        return this.distributeWork(data);
    }

    protected IFuture<AreaData> distributeWork(final AreaData data) {
        final Future ret = new Future();
        HashSet<AreaData> areas = new HashSet<AreaData>();
        long task = (long)data.getTaskSize() * (long)data.getTaskSize() * 256L;
        long pic = (long)data.getSizeX() * (long)data.getSizeY() * (long)data.getMax();
        int numx = (int)Math.max(Math.round(Math.sqrt((double)pic / (double)task)), 1L);
        double areawidth = data.getXEnd() - data.getXStart();
        double areaheight = data.getYEnd() - data.getYStart();
        int numx0 = numx;
        int resty = data.getSizeY();
        for (int numy = (int)Math.max(Math.round((double)pic / (double)(task * (long)numx)), 1L); numy > 0; --numy) {
            int sizey = (int)Math.round((double)resty / (double)numy);
            double ystart = data.getYStart() + areaheight * (((double)data.getSizeY() - (double)resty) / (double)data.getSizeY());
            double yend = data.getYStart() + areaheight * (((double)data.getSizeY() - (double)(resty - sizey)) / (double)data.getSizeY());
            int restx = data.getSizeX();
            for (numx = numx0; numx > 0; --numx) {
                int sizex = (int)Math.round((double)restx / (double)numx);
                double xstart = data.getXStart() + areawidth * (((double)data.getSizeX() - (double)restx) / (double)data.getSizeX());
                double xend = data.getXStart() + areawidth * (((double)data.getSizeX() - (double)(restx - sizex)) / (double)data.getSizeX());
                areas.add(new AreaData(xstart, xend, ystart, yend, data.getSizeX() - restx, data.getSizeY() - resty, sizex, sizey, data.getMax(), 0, 0, data.getAlgorithm(), null, null, data.getDisplayId()));
                restx -= sizex;
            }
            resty -= sizey;
        }
        data.setData(new short[data.getSizeX()][data.getSizeY()]);
        final int number = areas.size();
        this.manager.setMax(data.getParallel());
        this.manager.performTasks(areas, true, data).addResultListener((IResultListener)((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<Object>(){
            int cnt = 0;

            public void resultAvailable(Collection result) {
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println("ex: " + exception);
                ret.setExceptionIfUndone(exception);
            }

            public void intermediateResultAvailable(Object result) {
                AreaData ad = (AreaData)result;
                int xs = ad.getXOffset();
                int ys = ad.getYOffset();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GenerateService.this.panel.getStatusBar().setText("Finished: " + ++cnt + "(" + number + ")");
                    }
                });
                for (int yi = 0; yi < ad.getSizeY(); ++yi) {
                    for (int xi = 0; xi < ad.getSizeX(); ++xi) {
                        try {
                            data.fetchData()[xs + xi][ys + yi] = ad.fetchData()[xi][yi];
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            public void finished() {
                ret.setResult((Object)data);
            }
        }));
        return ret;
    }
}

