/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.IFractalAlgorithm;

public class LyapunovAlgorithm
implements IFractalAlgorithm {
    public static final String GENERATOR = "AAAAABBBBB";

    @Override
    public short determineColor(double a, double b, short max) {
        double sum = 0.0;
        double x = 0.5;
        for (int i = 1; i < max; ++i) {
            double r = GENERATOR.charAt(i % GENERATOR.length()) == 'A' ? a : b;
            x = r * x * (1.0 - x);
            double val = r * (1.0 - 2.0 * x);
            sum += Math.log(Math.abs(val));
        }
        double lambda = sum / (double)max;
        short val = sum > 0.0 ? (short)-1 : (short)(-Math.tanh(lambda) * (double)(max - 1));
        return val;
    }

    @Override
    public AreaData getDefaultSettings() {
        return new AreaData(1.7, 4.0, 2.7, 4.2, 230, 150, 160, 10, 300, this, null);
    }

    @Override
    public boolean useColorCycle() {
        return false;
    }

    @Override
    public boolean isOptimizationAllowed() {
        return false;
    }

    public String toString() {
        return "Lyapunov";
    }

    public boolean equals(Object obj) {
        return obj instanceof LyapunovAlgorithm;
    }

    public int hashCode() {
        return 31 + this.getClass().hashCode();
    }
}

