/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.micro.examples.mandelbrot.AreaData;
import jadex.micro.examples.mandelbrot.IFractalAlgorithm;

public class MandelbrotAlgorithm
implements IFractalAlgorithm {
    @Override
    public short determineColor(double xn, double yn, short max) {
        double x0 = xn;
        double y0 = yn;
        short i = 0;
        double c = Math.sqrt(xn * xn + yn * yn);
        for (i = 0; c < 2.0 && i < max; i = (short)(i + 1)) {
            double xn1 = xn * xn - yn * yn + x0;
            double yn1 = 2.0 * xn * yn + y0;
            xn = xn1;
            yn = yn1;
            c = Math.sqrt(xn * xn + yn * yn);
        }
        return i == max ? (short)-1 : (short)i;
    }

    @Override
    public boolean isOptimizationAllowed() {
        return true;
    }

    @Override
    public AreaData getDefaultSettings() {
        return new AreaData(-2.0, 1.0, -1.5, 1.5, 100, 100, 256, 10, 300, this, null);
    }

    @Override
    public boolean useColorCycle() {
        return true;
    }

    public String toString() {
        return "Mandelbrot";
    }

    public boolean equals(Object obj) {
        return obj instanceof MandelbrotAlgorithm;
    }

    public int hashCode() {
        return 31 + this.getClass().hashCode();
    }
}

