/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.mandelbrot;

import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.IService;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.clock.ITimedObject;
import jadex.bridge.service.types.clock.ITimer;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.micro.examples.mandelbrot.IServicePoolHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServicePoolManager {
    protected IInternalAccess component;
    protected String name;
    protected IServicePoolHandler handler;
    protected int max;
    protected Map free;
    protected Map busy;
    protected Map tasks;
    protected boolean searching;
    protected boolean creating;
    protected ITimer timer;

    public ServicePoolManager(IInternalAccess component, String name, IServicePoolHandler handler, int max) {
        this.component = component;
        this.name = name;
        this.handler = handler;
        this.max = max;
        this.free = new HashMap();
        this.busy = new HashMap();
        this.tasks = new HashMap();
    }

    public IIntermediateFuture performTasks(Set tasks, boolean retry, Object user) {
        AllocationData ad = new AllocationData(tasks.size(), retry, user);
        boolean allassigned = true;
        Iterator it = tasks.iterator();
        while (it.hasNext()) {
            boolean assigned = this.retryTask(it.next(), ad);
            allassigned = allassigned && assigned;
        }
        if (!allassigned && this.busy.size() + this.free.size() < this.max) {
            this.searchServices();
        }
        return ad.getResult();
    }

    public void setMax(int max) {
        this.max = max;
    }

    protected boolean retryTask(Object task, AllocationData ad) {
        boolean assigned = false;
        this.tasks.put(task, ad);
        if (!this.free.isEmpty()) {
            Iterator it = this.free.values().iterator();
            IService service = (IService)it.next();
            it.remove();
            this.addService(service);
            assigned = true;
        }
        return assigned;
    }

    protected void searchServices() {
        if (this.timer == null) {
            ((IRequiredServicesFeature)this.component.getComponentFeature(IRequiredServicesFeature.class)).searchService(IClockService.class, "platform").addResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    IClockService cs = (IClockService)result;
                    if (ServicePoolManager.this.timer == null) {
                        ServicePoolManager.this.timer = cs.createTimer(1000L, new ITimedObject(){

                            public void timeEventOccurred(long currenttime) {
                                ServicePoolManager.this.component.getExternalAccess().scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                    public IFuture<Void> execute(IInternalAccess ia) {
                                        ServicePoolManager.this.timer = null;
                                        ServicePoolManager.this.createServices();
                                        return IFuture.DONE;
                                    }

                                    public String toString() {
                                        return "Search timeout for: " + ServicePoolManager.this.name;
                                    }
                                });
                            }
                        });
                    }
                }

                public void exceptionOccurred(Exception exception) {
                }
            });
        }
        if (!this.searching) {
            this.searching = true;
            ((IRequiredServicesFeature)this.component.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices(this.name).addResultListener((IResultListener)new IIntermediateResultListener<Object>(){

                public void intermediateResultAvailable(Object result) {
                    IService service = (IService)result;
                    if (!ServicePoolManager.this.busy.containsKey(service.getServiceIdentifier()) && !ServicePoolManager.this.free.containsKey(service.getServiceIdentifier()) && ServicePoolManager.this.handler.selectService(service)) {
                        ServicePoolManager.this.addService(service);
                    }
                }

                public void finished() {
                    ServicePoolManager.this.searching = false;
                    if (ServicePoolManager.this.timer != null) {
                        ServicePoolManager.this.timer.cancel();
                        ServicePoolManager.this.timer = null;
                    }
                    ServicePoolManager.this.createServices();
                }

                public void exceptionOccurred(Exception exception) {
                    ServicePoolManager.this.searching = false;
                    if (ServicePoolManager.this.timer != null) {
                        ServicePoolManager.this.timer.cancel();
                        ServicePoolManager.this.timer = null;
                    }
                    if (!(exception instanceof ComponentTerminatedException) || !((ComponentTerminatedException)exception).getComponentIdentifier().equals(ServicePoolManager.this.component.getComponentIdentifier())) {
                        ServicePoolManager.this.createServices();
                    }
                }

                public void resultAvailable(Collection result) {
                    ServicePoolManager.this.searching = false;
                }
            });
        }
    }

    protected void addService(final IService service) {
        assert (!this.busy.containsKey(service.getServiceIdentifier()) && !this.free.containsKey(service.getServiceIdentifier()));
        if (this.tasks.isEmpty()) {
            this.free.put(service.getServiceIdentifier(), service);
        } else {
            this.busy.put(service.getServiceIdentifier(), service);
            final Object task = this.tasks.keySet().iterator().next();
            final AllocationData ad = (AllocationData)this.tasks.remove(task);
            this.handler.invokeService(service, task, ad.getUserData()).addResultListener(((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    ad.taskFinished(result);
                    ServicePoolManager.this.busy.remove(service.getServiceIdentifier());
                    ServicePoolManager.this.addService(service);
                }

                public void exceptionOccurred(Exception exception) {
                    if (ad.isRetry()) {
                        boolean assigned = ServicePoolManager.this.retryTask(task, ad);
                        if (!assigned) {
                            ServicePoolManager.this.searchServices();
                        }
                    } else {
                        ad.taskFailed(exception);
                    }
                    ServicePoolManager.this.busy.remove(service.getServiceIdentifier());
                }
            }));
        }
    }

    protected void createServices() {
        if (!(this.timer != null || this.creating || this.tasks.isEmpty() || this.max != -1 && this.free.size() + this.busy.size() >= this.max)) {
            this.creating = true;
            this.handler.createService().addResultListener(((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                public void resultAvailable(Object result) {
                    ServicePoolManager.this.creating = false;
                    IService service = (IService)result;
                    if (!ServicePoolManager.this.busy.containsKey(service.getServiceIdentifier()) && !ServicePoolManager.this.free.containsKey(service.getServiceIdentifier())) {
                        ServicePoolManager.this.addService((IService)result);
                    }
                    ServicePoolManager.this.createServices();
                }

                public void exceptionOccurred(Exception exception) {
                    ServicePoolManager.this.creating = false;
                }
            }));
        }
    }

    public static class AllocationData {
        protected int open;
        protected boolean retry;
        protected Object user;
        protected IntermediateFuture result;

        public AllocationData(int open, boolean retry, Object user) {
            this.open = open;
            this.retry = retry;
            this.user = user;
            this.result = new IntermediateFuture();
        }

        public Object getUserData() {
            return this.user;
        }

        public IntermediateFuture getResult() {
            return this.result;
        }

        public void taskFinished(Object result) {
            this.result.addIntermediateResult(result);
            --this.open;
            if (this.open == 0) {
                this.result.setFinished();
            }
        }

        public void taskFailed(Exception e) {
            e.printStackTrace();
            --this.open;
            if (this.open == 0) {
                this.result.setFinished();
            }
        }

        public boolean isRetry() {
            return this.retry;
        }
    }
}

