/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.messagequeue;

import jadex.bridge.IInternalAccess;
import jadex.bridge.SFuture;
import jadex.bridge.service.annotation.Service;
import jadex.commons.future.IFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.examples.messagequeue.Event;
import jadex.micro.examples.messagequeue.IMessageQueueService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=IMessageQueueService.class, implementation=@Implementation(expression="$pojoagent"))})
public class MessageQueueAgent
implements IMessageQueueService {
    @Agent
    protected IInternalAccess agent;
    protected Map<String, List<SubscriptionIntermediateFuture<Event>>> subscribers;

    @AgentCreated
    public void agentCreated() {
        this.subscribers = new HashMap<String, List<SubscriptionIntermediateFuture<Event>>>();
    }

    @Override
    public ISubscriptionIntermediateFuture<Event> subscribe(String topic) {
        SubscriptionIntermediateFuture ret = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IInternalAccess)this.agent);
        List<SubscriptionIntermediateFuture<Event>> subs = this.subscribers.get(topic);
        if (subs == null) {
            subs = new ArrayList<SubscriptionIntermediateFuture<Event>>();
            this.subscribers.put(topic, subs);
        }
        subs.add((SubscriptionIntermediateFuture<Event>)ret);
        return ret;
    }

    @Override
    public IFuture<Void> publish(String topic, Event event) {
        List<SubscriptionIntermediateFuture<Event>> subs = this.subscribers.get(topic);
        if (subs != null) {
            Iterator<SubscriptionIntermediateFuture<Event>> it = subs.iterator();
            while (it.hasNext()) {
                SubscriptionIntermediateFuture<Event> sub = it.next();
                if (sub.addIntermediateResultIfUndone((Object)event)) continue;
                System.out.println("Removed: " + sub);
                it.remove();
            }
            if (subs.isEmpty()) {
                this.subscribers.remove(topic);
            }
        }
        return IFuture.DONE;
    }
}

