/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.messagequeue;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.messagequeue.Event;
import jadex.micro.examples.messagequeue.IMessageQueueService;

@Agent
@RequiredServices(value={@RequiredService(name="mq", type=IMessageQueueService.class)})
@Arguments(value={@Argument(name="topic", clazz=String.class, defaultvalue="\"default_topic\"")})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;
    @AgentService
    protected IMessageQueueService mq;
    @AgentArgument
    protected String topic;

    @AgentBody
    public void body() {
        final ISubscriptionIntermediateFuture<Event> fut = this.mq.subscribe(this.topic);
        fut.addResultListener((IResultListener)new IntermediateDefaultResultListener<Event>(){

            public void intermediateResultAvailable(Event event) {
                System.out.println("Received: " + UserAgent.this.agent.getComponentIdentifier() + " " + event);
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println("Ex: " + exception);
            }
        });
        IComponentStep<Void> step = new IComponentStep<Void>(){
            final int[] cnt = new int[1];

            public IFuture<Void> execute(IInternalAccess ia) {
                int n = this.cnt[0];
                this.cnt[0] = n + 1;
                UserAgent.this.mq.publish(UserAgent.this.topic, new Event("some type", n, UserAgent.this.agent.getComponentIdentifier()));
                if (this.cnt[0] < 10) {
                    ((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)this);
                } else {
                    fut.terminate();
                }
                return IFuture.DONE;
            }
        };
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)step);
    }
}

