/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.messagequeue.replicated;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.SFuture;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.messagequeue.Event;
import jadex.micro.examples.messagequeue.replicated.IMessageQueueReplicableService;
import jadex.micro.examples.messagequeue.replicated.IMessageQueueReplicationService;
import jadex.micro.examples.messagequeue.replicated.ReplicationSubscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=IMessageQueueReplicableService.class, implementation=@Implementation(expression="$pojoagent")), @ProvidedService(type=IMessageQueueReplicationService.class, implementation=@Implementation(expression="$pojoagent"))})
@RequiredServices(value={@RequiredService(type=IMessageQueueReplicationService.class, multiple=true, binding=@Binding(scope="global"), name="replication")})
@Arguments(value={@Argument(name="searchinterval", clazz=Integer.class, defaultvalue="1000")})
public class ReplicatedMessageQueueAgent
implements IMessageQueueReplicableService,
IMessageQueueReplicationService {
    @Agent
    protected IInternalAccess agent;
    protected Map<String, List<SubscriptionIntermediateFuture<Event>>> localsubscribers;
    protected Map<String, List<SubscriptionIntermediateFuture<Event>>> repsubscribers;
    protected Map<String, List<ReplicationSubscription>> repsubscriptions;
    protected String id;
    @AgentArgument
    protected Integer searchinterval;

    @AgentCreated
    public void agentCreated() {
        this.localsubscribers = new HashMap<String, List<SubscriptionIntermediateFuture<Event>>>();
        this.repsubscribers = new HashMap<String, List<SubscriptionIntermediateFuture<Event>>>();
        this.repsubscriptions = new HashMap<String, List<ReplicationSubscription>>();
        this.id = this.agent.getComponentIdentifier().getName();
    }

    @AgentBody
    public void agentBody() {
        IComponentStep<Void> searchServicesStep = new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                ReplicatedMessageQueueAgent.this.getOtherServices().addResultListener((IResultListener)new IntermediateDefaultResultListener<IMessageQueueReplicationService>(){

                    public void intermediateResultAvailable(IMessageQueueReplicationService result) {
                        for (final String topic : ReplicatedMessageQueueAgent.this.repsubscriptions.keySet()) {
                            boolean present = false;
                            for (ReplicationSubscription repsub : ReplicatedMessageQueueAgent.this.repsubscriptions.get(topic)) {
                                if (!repsub.getService().equals(result)) continue;
                                present = true;
                                break;
                            }
                            if (present || result.getId().equals(ReplicatedMessageQueueAgent.this.id)) continue;
                            ISubscriptionIntermediateFuture<Event> subscription = result.subscribeForReplication(topic);
                            ReplicationSubscription replicationSubscription = new ReplicationSubscription(result, subscription);
                            ReplicatedMessageQueueAgent.this.repsubscriptions.get(topic).add(replicationSubscription);
                            subscription.addResultListener((IResultListener)new IntermediateDefaultResultListener<Event>(){

                                public void intermediateResultAvailable(Event result) {
                                    ReplicatedMessageQueueAgent.this.publish(topic, result);
                                }
                            });
                        }
                    }
                });
                ((IExecutionFeature)ReplicatedMessageQueueAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay((long)ReplicatedMessageQueueAgent.this.searchinterval.intValue(), (IComponentStep)this);
                return IFuture.DONE;
            }
        };
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForTick((IComponentStep)searchServicesStep);
    }

    @Override
    public ISubscriptionIntermediateFuture<Event> subscribeForReplication(String topic) {
        SubscriptionIntermediateFuture ret = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IInternalAccess)this.agent);
        List<SubscriptionIntermediateFuture<Event>> subs = this.repsubscribers.get(topic);
        if (subs == null) {
            subs = new ArrayList<SubscriptionIntermediateFuture<Event>>();
            this.repsubscribers.put(topic, subs);
        }
        subs.add((SubscriptionIntermediateFuture<Event>)ret);
        return ret;
    }

    private void replicate(String topic, Event event) {
        List<SubscriptionIntermediateFuture<Event>> subs = this.repsubscribers.get(topic);
        if (subs != null) {
            Iterator<SubscriptionIntermediateFuture<Event>> it = subs.iterator();
            while (it.hasNext()) {
                SubscriptionIntermediateFuture<Event> sub = it.next();
                if (sub.addIntermediateResultIfUndone((Object)event)) continue;
                System.out.println("Removed: " + sub);
                it.remove();
            }
            if (subs.isEmpty()) {
                this.repsubscribers.remove(topic);
            }
        }
    }

    @Override
    public ISubscriptionIntermediateFuture<Event> subscribe(String topic) {
        SubscriptionIntermediateFuture ret = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IInternalAccess)this.agent);
        List<SubscriptionIntermediateFuture<Event>> subs = this.localsubscribers.get(topic);
        if (subs == null) {
            subs = new ArrayList<SubscriptionIntermediateFuture<Event>>();
            this.localsubscribers.put(topic, subs);
        }
        subs.add((SubscriptionIntermediateFuture<Event>)ret);
        this.subscribeRemote(topic);
        return ret;
    }

    private void subscribeRemote(final String topic) {
        this.getOtherServices().addResultListener((IResultListener)new IntermediateDefaultResultListener<IMessageQueueReplicationService>(){

            public void intermediateResultAvailable(IMessageQueueReplicationService result) {
                List<Object> subscriptions;
                boolean present = false;
                if (ReplicatedMessageQueueAgent.this.repsubscriptions.containsKey(topic)) {
                    subscriptions = ReplicatedMessageQueueAgent.this.repsubscriptions.get(topic);
                    for (ReplicationSubscription replicationSubscription : subscriptions) {
                        if (!replicationSubscription.getService().equals(result)) continue;
                        present = true;
                        break;
                    }
                } else {
                    subscriptions = new ArrayList();
                    ReplicatedMessageQueueAgent.this.repsubscriptions.put(topic, subscriptions);
                }
                if (!present && !result.getId().equals(ReplicatedMessageQueueAgent.this.id)) {
                    ISubscriptionIntermediateFuture<Event> subscription = result.subscribeForReplication(topic);
                    ReplicationSubscription replicationSubscription = new ReplicationSubscription(result, subscription);
                    ReplicatedMessageQueueAgent.this.repsubscriptions.get(topic).add(replicationSubscription);
                    subscription.addResultListener((IResultListener)new IntermediateDefaultResultListener<Event>(){

                        public void intermediateResultAvailable(Event result) {
                            ReplicatedMessageQueueAgent.this.publish(topic, result);
                        }
                    });
                }
            }
        });
    }

    @Override
    public IFuture<Void> publish(String topic, Event event, Boolean replicate) {
        List<SubscriptionIntermediateFuture<Event>> subs = this.localsubscribers.get(topic);
        if (subs != null) {
            Iterator<SubscriptionIntermediateFuture<Event>> it = subs.iterator();
            while (it.hasNext()) {
                SubscriptionIntermediateFuture<Event> sub = it.next();
                if (sub.addIntermediateResultIfUndone((Object)event)) continue;
                System.out.println("Removed: " + sub);
                it.remove();
            }
            if (subs.isEmpty()) {
                this.removeTopic(topic);
            }
        }
        if (replicate.booleanValue()) {
            this.replicate(topic, event);
        }
        return IFuture.DONE;
    }

    private void removeTopic(String topic) {
        this.localsubscribers.remove(topic);
        List<ReplicationSubscription> replicationSubscriptions = this.repsubscriptions.get(topic);
        for (ReplicationSubscription replicationSubscription : replicationSubscriptions) {
            replicationSubscription.getSubscription().terminate();
        }
    }

    private IIntermediateFuture<IMessageQueueReplicationService> getOtherServices() {
        return ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("replication");
    }

    @Override
    public IFuture<Void> publish(String topic, Event event) {
        return this.publish(topic, event, false);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

