/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.ping;

import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IMessageFeature;
import jadex.bridge.service.types.message.MessageType;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentMessageArrived;
import java.util.Map;

@Agent
public class PingAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentMessageArrived
    public void messageArrived(Map<String, Object> msg, MessageType mt) {
        String perf = (String)msg.get("performative");
        if (("query-if".equals(perf) || "query-ref".equals(perf)) && "ping".equals(msg.get("content"))) {
            Map reply = mt.createReply(msg);
            reply.put("content", "alive");
            reply.put("performative", "inform");
            reply.put("sender", this.agent.getComponentIdentifier());
            ((IMessageFeature)this.agent.getComponentFeature(IMessageFeature.class)).sendMessage(reply, mt);
        } else {
            this.agent.getLogger().severe("Could not process message: " + msg);
        }
    }
}

