/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.ping;

import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.IMessageFeature;
import jadex.bridge.fipa.SFipa;
import jadex.bridge.service.types.message.MessageType;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentMessageArrived;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Description;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Description(value="A simple agent that sends pings to another agent and waits for replies.")
@Arguments(value={@Argument(name="receiver", clazz=IComponentIdentifier.class, description="The component receiver of the ping target."), @Argument(name="missed_max", clazz=int.class, description="Maximum number of allowed missed replies", defaultvalue="3"), @Argument(name="timeout", clazz=long.class, description="Timeout for reply", defaultvalue="1000"), @Argument(name="content", clazz=String.class, description="Ping message content", defaultvalue="\"ping\"")})
@Agent
public class PingingAgent {
    @Agent
    protected IInternalAccess agent;
    protected IComponentIdentifier receiver;
    protected int dif;
    protected Set<String> sent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        this.receiver = (IComponentIdentifier)((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("receiver");
        final int missed_max = ((Number)((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("missed_max")).intValue();
        final long timeout = ((Number)((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("timeout")).longValue();
        final Object content = ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("content");
        this.sent = new HashSet<String>();
        IComponentStep<Void> step = new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                if (PingingAgent.this.dif > missed_max) {
                    PingingAgent.this.agent.getLogger().warning("Ping target does not respond: " + PingingAgent.this.receiver);
                    ret.setResult(null);
                } else {
                    String convid = SUtil.createUniqueId((String)PingingAgent.this.agent.getComponentIdentifier().getName());
                    HashMap<String, Object> msg = new HashMap<String, Object>();
                    msg.put("content", content);
                    msg.put("performative", "query-if");
                    msg.put("conversation_id", convid);
                    msg.put("receivers", new IComponentIdentifier[]{PingingAgent.this.receiver});
                    ++PingingAgent.this.dif;
                    PingingAgent.this.sent.add(convid);
                    ((IMessageFeature)PingingAgent.this.agent.getComponentFeature(IMessageFeature.class)).sendMessage(msg, SFipa.FIPA_MESSAGE_TYPE);
                    ((IExecutionFeature)PingingAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(timeout, (IComponentStep)this);
                }
                return IFuture.DONE;
            }
        };
        if (this.receiver == null) {
            this.receiver = new BasicComponentIdentifier("Ping", this.agent.getComponentIdentifier().getParent());
        }
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)step);
        return ret;
    }

    @AgentMessageArrived
    public void messageArrived(Map<String, Object> msg, MessageType mt) {
        String convid;
        if (mt.equals((Object)SFipa.FIPA_MESSAGE_TYPE) && this.sent.remove(convid = (String)msg.get("conversation_id"))) {
            this.dif = 0;
            this.sent.clear();
        }
    }
}

