/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.examples.watchdog;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.examples.watchdog.IWatchdogService;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

@ProvidedServices(value={@ProvidedService(type=IWatchdogService.class, implementation=@Implementation(expression="$pojoagent"))})
@RequiredServices(value={@RequiredService(name="watchdogs", type=IWatchdogService.class, multiple=true, binding=@Binding(scope="global", dynamic=true))})
@Arguments(value={@Argument(clazz=long.class, name="delay", description="Delay between pings.", defaultvalue="3000")})
@Service
@Agent
public class WatchdogAgent
implements IWatchdogService {
    @Agent
    protected IInternalAccess agent;
    protected Map watchdogs;

    public IFuture<Void> agentCreated() {
        try {
            this.watchdogs = new LinkedHashMap();
            final long delay = ((Number)((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("delay")).longValue();
            ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                public IFuture<Void> execute(IInternalAccess ia) {
                    final 1 step = this;
                    Object[] keys = WatchdogAgent.this.watchdogs.keySet().toArray();
                    CounterResultListener crl = new CounterResultListener(keys.length, new IResultListener(){

                        public void resultAvailable(Object result) {
                            ((IRequiredServicesFeature)WatchdogAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("watchdogs").addResultListener(new IResultListener(){

                                public void resultAvailable(Object result) {
                                    if (result instanceof Collection) {
                                        for (IWatchdogService watchdog : (Collection)result) {
                                            if (watchdog.getInfo().equals(WatchdogAgent.this.getInfo())) continue;
                                            WatchdogAgent.this.watchdogs.put(watchdog.getInfo(), watchdog);
                                        }
                                    }
                                    ((IExecutionFeature)WatchdogAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(delay, step);
                                }

                                public void exceptionOccurred(Exception exception) {
                                    WatchdogAgent.this.agent.getLogger().warning("Exception occurred: " + exception);
                                }
                            });
                        }

                        public void exceptionOccurred(Exception exception) {
                            WatchdogAgent.this.agent.getLogger().warning("Exception occurred: " + exception);
                        }
                    });
                    for (int i = 0; i < keys.length; ++i) {
                        Object key = keys[i];
                        IWatchdogService watchdog = (IWatchdogService)WatchdogAgent.this.watchdogs.get(key);
                        watchdog.ping().addResultListener(new IResultListener((IResultListener)crl, key){
                            final /* synthetic */ IResultListener val$crl;
                            final /* synthetic */ Object val$key;
                            {
                                this.val$crl = iResultListener;
                                this.val$key = object;
                            }

                            public void resultAvailable(Object result) {
                                this.val$crl.resultAvailable(null);
                            }

                            public void exceptionOccurred(Exception exception) {
                                System.out.println("Watchdog triggered: " + this.val$key);
                                WatchdogAgent.this.watchdogs.remove(this.val$key);
                                this.val$crl.resultAvailable(null);
                            }
                        });
                    }
                    return IFuture.DONE;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return IFuture.DONE;
    }

    @Override
    public String getInfo() {
        return this.agent.getComponentIdentifier().getName();
    }

    public IFuture<Void> ping() {
        return IFuture.DONE;
    }
}

