/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.quickstart;

import jadex.bridge.service.IService;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.quickstart.ITimeService;

@Agent
@RequiredServices(value={@RequiredService(name="timeservices", type=ITimeService.class, multiple=true, binding=@Binding(scope="global"))})
public class BlockingTimeUserAgent {
    @AgentService
    public void addTimeService(ITimeService timeservice) {
        ISubscriptionIntermediateFuture<String> subscription = timeservice.subscribe();
        while (subscription.hasNextIntermediateResult()) {
            String time = (String)subscription.getNextIntermediateResult();
            String platform = ((IService)timeservice).getServiceIdentifier().getProviderId().getPlatformName();
            System.out.println("New time received from " + platform + " at " + timeservice.getLocation() + ": " + time);
        }
    }
}

