/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.quickstart;

import jadex.base.Starter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.commons.future.TerminationCommand;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.quickstart.ITimeService;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.Set;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=ITimeService.class)})
public class TimeProviderAgent
implements ITimeService,
IComponentStep<Void> {
    @Agent
    protected IInternalAccess agent;
    protected String location = TimeProviderAgent.determineLocation();
    protected Set<SubscriptionIntermediateFuture<String>> subscriptions = new LinkedHashSet<SubscriptionIntermediateFuture<String>>();

    @AgentBody
    public IFuture<Void> execute(IInternalAccess ia) {
        Date d = new Date(System.currentTimeMillis() - System.currentTimeMillis() % 5000L);
        for (SubscriptionIntermediateFuture<String> subscriber : this.subscriptions) {
            subscriber.addIntermediateResultIfUndone((Object)d.toString());
        }
        long millis = d.getTime() + 5000L - System.currentTimeMillis();
        ((IExecutionFeature)ia.getComponentFeature(IExecutionFeature.class)).waitForDelay(millis, (IComponentStep)this);
        return new Future();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public ISubscriptionIntermediateFuture<String> subscribe() {
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture();
        this.subscriptions.add((SubscriptionIntermediateFuture<String>)ret);
        ret.setTerminationCommand((ITerminationCommand)new TerminationCommand(){

            public void terminated(Exception reason) {
                System.out.println("removed subscriber due to: " + reason);
                TimeProviderAgent.this.subscriptions.remove(ret);
            }
        });
        return ret;
    }

    protected static String determineLocation() {
        final Future fut = new Future();
        new Thread(new Runnable(){

            @Override
            public void run() {
                String ret = "unknown";
                try {
                    Scanner scanner = new Scanner(new URL("http://freegeoip.net/csv/").openStream(), "UTF-8");
                    scanner.findInLine("([^,]*),");
                    scanner.findInLine("([^,]*),");
                    scanner.findInLine("([^,]*),");
                    ret = scanner.match().group(1);
                    scanner.findInLine("([^,]*),");
                    scanner.findInLine("([^,]*),");
                    ret = scanner.match().group(1) + ", " + ret;
                    scanner.close();
                }
                catch (Exception e) {
                    System.err.println("Cannot determine location: " + e);
                }
                fut.setResult((Object)ret);
            }
        }).start();
        try {
            return (String)fut.get(Starter.getScaledRemoteDefaultTimeout((IComponentIdentifier)((IComponentIdentifier)IComponentIdentifier.LOCAL.get()), (double)0.8));
        }
        catch (TimeoutException e) {
            return "unknown";
        }
    }

    public static void main(String[] args) throws Exception {
        int read;
        InputStream is = new URL("http://freegeoip.net/csv/").openStream();
        byte[] buf = new byte[1234];
        while ((read = is.read(buf)) != -1) {
            System.out.write(buf, 0, read);
        }
        is.close();
    }
}

