/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.quickstart;

import jadex.bridge.service.IService;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.quickstart.ITimeService;

@Agent
@RequiredServices(value={@RequiredService(name="timeservices", type=ITimeService.class, multiple=true, binding=@Binding(scope="global"))})
public class TimeUserAgent {
    @AgentService
    private IIntermediateFuture<ITimeService> timeservices;

    @AgentBody
    public void body() {
        this.timeservices.addResultListener((IResultListener)new IntermediateDefaultResultListener<ITimeService>(){

            public void intermediateResultAvailable(final ITimeService timeservice) {
                ISubscriptionIntermediateFuture<String> subscription = timeservice.subscribe();
                subscription.addResultListener((IResultListener)new IntermediateDefaultResultListener<String>(){

                    public void intermediateResultAvailable(String time) {
                        String platform = ((IService)timeservice).getServiceIdentifier().getProviderId().getPlatformName();
                        System.out.println("New time received from " + platform + " at " + timeservice.getLocation() + ": " + time);
                    }
                });
            }
        });
    }
}

