/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.servicecall;

import jadex.base.test.TestReport;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.IService;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.servicecall.DecoupledServiceAgent;
import jadex.micro.servicecall.DirectServiceAgent;
import jadex.micro.servicecall.IServiceCallService;
import jadex.micro.servicecall.RawServiceAgent;
import jadex.micro.testcases.TestAgent;
import java.util.Map;

@RequiredServices(value={@RequiredService(name="raw", type=IServiceCallService.class, binding=@Binding(proxytype="raw", dynamic=true, scope="global")), @RequiredService(name="direct", type=IServiceCallService.class, binding=@Binding(proxytype="direct", dynamic=true, scope="global")), @RequiredService(name="decoupled", type=IServiceCallService.class, binding=@Binding(proxytype="decoupled", dynamic=true, scope="global")), @RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
@Agent
@Arguments(replace=false, value={@Argument(name="max", clazz=int.class, defaultvalue="10")})
public class ServiceCallAgent
extends TestAgent {
    @Agent
    protected IInternalAccess agent;
    @Agent
    protected IInternalAccess ag;
    @AgentArgument
    protected int max;

    @Override
    protected IFuture<TestReport> test(final IComponentManagementService cms, final boolean local) {
        final Future ret = new Future();
        this.performTests(cms, RawServiceAgent.class.getName() + ".class", local ? 2000 : 1).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

            public void customResultAvailable(Void result) {
                ServiceCallAgent.this.performTests(cms, DirectServiceAgent.class.getName() + ".class", local ? 200 : 1).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

                    public void customResultAvailable(Void result) {
                        ServiceCallAgent.this.performTests(cms, DecoupledServiceAgent.class.getName() + ".class", local ? 100 : 1).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

                            public void customResultAvailable(Void result) {
                                ret.setResult((Object)new TestReport("#1", "test", true, null));
                            }
                        });
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<Void> performTests(final IComponentManagementService cms, String agentname, final int factor) {
        final Future ret = new Future();
        CreationInfo ci = ((IService)cms).getServiceIdentifier().getProviderId().getPlatformName().equals(this.agent.getComponentIdentifier().getPlatformName()) ? new CreationInfo(this.agent.getComponentIdentifier(), this.agent.getModel().getResourceIdentifier()) : new CreationInfo(this.agent.getModel().getResourceIdentifier());
        cms.createComponent(null, agentname, ci, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Void>(ret){

            public void customResultAvailable(final IComponentIdentifier cid) {
                final Future ret2 = new Future();
                ServiceCallAgent.this.performSingleTest("raw", 5 * factor).addResultListener(((IExecutionFeature)ServiceCallAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<Void>(ret2){

                    public void customResultAvailable(Void result) {
                        ServiceCallAgent.this.performSingleTest("direct", 2 * factor).addResultListener(((IExecutionFeature)ServiceCallAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<Void>(ret2){

                            public void customResultAvailable(Void result) {
                                ServiceCallAgent.this.performSingleTest("decoupled", 1 * factor).addResultListener(((IExecutionFeature)ServiceCallAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret2)));
                            }
                        }));
                    }
                }));
                ret2.addResultListener((IResultListener)new IResultListener<Void>(){

                    public void exceptionOccurred(Exception exception) {
                        cms.destroyComponent(cid);
                        ret.setException(exception);
                    }

                    public void resultAvailable(Void result) {
                        cms.destroyComponent(cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<Map<String, Object>, Void>(ret){

                            public void customResultAvailable(Map<String, Object> result) {
                                ret.setResult(null);
                            }
                        });
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<Void> performSingleTest(final String servicename, final int factor) {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService(servicename);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IServiceCallService, Void>(ret){

            public void customResultAvailable(final IServiceCallService service) {
                DelegationResultListener<Void> lis = new DelegationResultListener<Void>(ret){
                    int count;
                    long start;
                    {
                        super(x0);
                        this.count = ServiceCallAgent.this.max * factor;
                        this.start = System.currentTimeMillis();
                    }

                    public void customResultAvailable(Void result) {
                        --this.count;
                        if (this.count == 0) {
                            long end = System.currentTimeMillis();
                            System.out.println(servicename + " service call on " + service + " took " + (double)((end - this.start) * 10000L / ((long)ServiceCallAgent.this.max * (long)factor)) / 10.0 + " microseconds per call (" + ServiceCallAgent.this.max * factor + " calls in " + (end - this.start) + " millis).");
                            ret.setResult(null);
                        } else {
                            service.call().addResultListener((IResultListener)this);
                        }
                    }
                };
                service.call().addResultListener((IResultListener)lis);
            }
        });
        return ret;
    }
}

