/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.showrooms;

import jadex.bridge.service.types.clock.IClockService;
import jadex.extension.envsupport.environment.AbstractTask;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.SpaceObject;
import jadex.extension.envsupport.environment.space3d.Space3D;
import jadex.extension.envsupport.math.Vector3Double;

public class RotationTask
extends AbstractTask {
    public void execute(IEnvironmentSpace space, ISpaceObject obj, long progress, IClockService cl) {
        ISpaceObject[] ispaceObjects = space.getSpaceObjectsByType("rotationplattform");
        int distance = ispaceObjects.length;
        SpaceObject me = (SpaceObject)((Space3D)space).getSpaceObject(obj.getId());
        me.setProperty("rotation", (Object)new Vector3Double(0.0, 0.0, 0.0));
        Long intme = (Long)me.getId();
        int integerme = intme.intValue();
        int tmp = 360 / distance * integerme;
        int clock = ((int)cl.getTick() + tmp) % 360;
        double radius = 0.5;
        double xcenter = 0.5;
        double ycenter = 0.5;
        double x = Math.cos((double)clock * Math.PI / 180.0) * radius + xcenter;
        double y = Math.sin((double)clock * Math.PI / 180.0) * radius + ycenter;
        if (cl.getTick() % 200.0 == 50.0) {
            me.setProperty("status", (Object)"Idle");
        }
        if (cl.getTick() % 200.0 == 100.0) {
            me.setProperty("status", (Object)"Walk");
        }
        if (cl.getTick() % 200.0 == 0.0) {
            me.setProperty("status", (Object)"Attack");
        }
        if (cl.getTick() % 200.0 == 150.0) {
            me.setProperty("status", (Object)"Nix");
        }
        me.setProperty("position", (Object)new Vector3Double(x, Math.sin((double)clock * Math.PI / 360.0) / 2.0, y));
    }
}

