/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.BrokenInitAgent;
import jadex.micro.testcases.PojoBrokenInitAgent;

@Agent
@Description(value="Testing broken init.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
public class BrokenInitTestAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final TestReport tr1 = new TestReport("#1", "Direct subcomponent.");
        this.testBrokenComponent(BrokenInitAgent.class.getName() + ".class").addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                tr1.setSucceeded(true);
                this.next();
            }

            public void exceptionOccurred(Exception exception) {
                tr1.setFailed(exception.getMessage());
                this.next();
            }

            protected void next() {
                final TestReport tr2 = new TestReport("#2", "Nested subcomponent.");
                BrokenInitTestAgent.this.testBrokenComponent("jadex/micro/testcases/BrokenInit.component.xml").addResultListener(((IExecutionFeature)BrokenInitTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        tr2.setSucceeded(true);
                        this.next();
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr2.setFailed(exception.getMessage());
                        this.next();
                    }

                    protected void next() {
                        final TestReport tr3 = new TestReport("#3", "Exception in agent created.");
                        BrokenInitTestAgent.this.testBrokenComponent(PojoBrokenInitAgent.class.getName() + ".class").addResultListener(((IExecutionFeature)BrokenInitTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

                            public void resultAvailable(Void result) {
                                tr3.setSucceeded(true);
                                this.next();
                            }

                            public void exceptionOccurred(Exception exception) {
                                tr3.setFailed(exception.getMessage());
                                this.next();
                            }

                            protected void next() {
                                ((IArgumentsResultsFeature)BrokenInitTestAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(3, new TestReport[]{tr1, tr2, tr3}));
                                ret.setResult(null);
                            }
                        }));
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<Void> testBrokenComponent(final String model) {
        final Future fut1 = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(fut1){

            public void customResultAvailable(final IComponentManagementService cms) {
                cms.createComponent(null, model, new CreationInfo(BrokenInitTestAgent.this.agent.getComponentIdentifier()), null).addResultListener(((IExecutionFeature)BrokenInitTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<IComponentIdentifier>(){

                    public void resultAvailable(IComponentIdentifier result) {
                        fut1.setException((Exception)new RuntimeException("Creation unexpectedly succeded."));
                        cms.destroyComponent(result);
                    }

                    public void exceptionOccurred(Exception exception) {
                        if (exception.getMessage().equals("Exception in init.")) {
                            fut1.setResult(null);
                        } else {
                            fut1.setException(exception);
                        }
                    }
                }));
            }
        });
        return fut1;
    }
}

