/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.Tuple2;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.BodyExceptionAgent;
import jadex.micro.testcases.PojoBodyExceptionAgent;
import java.util.Collection;

@Description(value="Testing broken components.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
@Agent
public class BrokenTestAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final TestReport tr1 = new TestReport("#1", "Body exception subcomponent.");
        this.testBrokenComponent(BodyExceptionAgent.class.getName() + ".class").addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                tr1.setSucceeded(true);
                this.next();
            }

            public void exceptionOccurred(Exception exception) {
                tr1.setFailed(exception.getMessage());
                this.next();
            }

            protected void next() {
                final TestReport tr3 = new TestReport("#3", "PojoBodyExceptionAgent");
                BrokenTestAgent.this.testBrokenComponent(PojoBodyExceptionAgent.class.getName() + ".class").addResultListener(((IExecutionFeature)BrokenTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        tr3.setSucceeded(true);
                        this.next();
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr3.setFailed(exception.getMessage());
                        this.next();
                    }

                    protected void next() {
                        ((IArgumentsResultsFeature)BrokenTestAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(2, new TestReport[]{tr1, tr3}));
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<Void> testBrokenComponent(final String model) {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                IResultListener<Collection<Tuple2<String, Object>>> lis = new IResultListener<Collection<Tuple2<String, Object>>>(){

                    public void resultAvailable(Collection<Tuple2<String, Object>> result) {
                        ret.setException((Exception)new RuntimeException("Terminated gracefully."));
                    }

                    public void exceptionOccurred(Exception exception) {
                        if (exception instanceof TimeoutException) {
                            ret.setExceptionIfUndone(exception);
                        } else {
                            ret.setResultIfUndone(null);
                        }
                    }
                };
                cms.createComponent(null, model, new CreationInfo(BrokenTestAgent.this.agent.getComponentIdentifier()), (IResultListener)lis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Void>(ret){

                    public void customResultAvailable(IComponentIdentifier result) {
                    }
                });
            }
        });
        return ret;
    }
}

