/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.Map;

@Description(value="Testing results declared in component configurations.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
@Agent
public class ComponentResultTest2Agent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final TestReport tr1 = new TestReport("#1", "Default configuration.");
        this.testComponentResult(null, "initial1").addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                tr1.setSucceeded(true);
                this.next();
            }

            public void exceptionOccurred(Exception exception) {
                tr1.setFailed(exception.getMessage());
                this.next();
            }

            protected void next() {
                final TestReport tr2 = new TestReport("#2", "Custom configuration");
                ComponentResultTest2Agent.this.testComponentResult("config2", "initial2").addResultListener(((IExecutionFeature)ComponentResultTest2Agent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                    public void resultAvailable(Object result) {
                        tr2.setSucceeded(true);
                        this.next();
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr2.setFailed(exception.getMessage());
                        this.next();
                    }

                    protected void next() {
                        ((IArgumentsResultsFeature)ComponentResultTest2Agent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(2, new TestReport[]{tr1, tr2}));
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture testComponentResult(final String config, final String expected) {
        final Future fut = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms").addResultListener((IResultListener)new DelegationResultListener(fut){

            public void customResultAvailable(Object result) {
                final IComponentManagementService cms = (IComponentManagementService)result;
                cms.createComponent(null, "jadex/micro/testcases/Result.component.xml", new CreationInfo(config, null, ComponentResultTest2Agent.this.agent.getComponentIdentifier()), null).addResultListener(((IExecutionFeature)ComponentResultTest2Agent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(fut){

                    public void customResultAvailable(Object result) {
                        cms.destroyComponent((IComponentIdentifier)result).addResultListener((IResultListener)new DelegationResultListener(fut){

                            public void customResultAvailable(Object result) {
                                Map results = (Map)result;
                                if (results == null || !SUtil.equals(results.get("res"), (Object)expected)) {
                                    throw new RuntimeException("Results do not match, expected res=" + expected + " but got: " + results);
                                }
                                super.customResultAvailable(null);
                            }
                        });
                    }
                }));
            }
        });
        return fut;
    }
}

