/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ISearchConstraints;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.IMessageFeature;
import jadex.bridge.fipa.SFipa;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.df.IDF;
import jadex.bridge.service.types.df.IDFComponentDescription;
import jadex.bridge.service.types.df.IDFServiceDescription;
import jadex.bridge.service.types.message.MessageType;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentKilled;
import jadex.micro.annotation.AgentMessageArrived;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Description(value="Test DF usage from micro agent.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Agent
public class DFTestAgent {
    @Agent
    protected IInternalAccess agent;
    protected List<TestReport> reports;

    @AgentBody
    public IFuture<Void> executeBody() {
        this.reports = new ArrayList<TestReport>();
        return this.registerDF();
    }

    @AgentKilled
    public IFuture<Void> agentKilled() {
        final Future ret = new Future();
        ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(this.reports.size(), this.reports.toArray(new TestReport[this.reports.size()])));
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IDF.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IDF, Void>(ret){

            public void customResultAvailable(IDF df) {
                IDFComponentDescription ad = df.createDFComponentDescription(DFTestAgent.this.agent.getComponentIdentifier(), null);
                df.deregister(ad).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return IFuture.DONE;
    }

    protected IFuture<Void> registerDF() {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#1", "Test DF registration.");
        this.reports.add(tr);
        SServiceProvider.getService((IInternalAccess)this.agent, IDF.class, (String)"platform").addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener<IDF>(){

            public void resultAvailable(IDF df) {
                IDFServiceDescription sd = df.createDFServiceDescription(null, "testType", null);
                IDFComponentDescription ad = df.createDFComponentDescription(DFTestAgent.this.agent.getComponentIdentifier(), sd);
                IFuture re = df.register(ad);
                re.addResultListener(((IExecutionFeature)DFTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<IDFComponentDescription>(){

                    public void resultAvailable(IDFComponentDescription result) {
                        tr.setSucceeded(true);
                        DFTestAgent.this.searchDF().addResultListener(((IExecutionFeature)DFTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }

                    public void exceptionOccurred(Exception e) {
                        tr.setFailed(e.toString());
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<Void> searchDF() {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#2", "Test DF search.");
        this.reports.add(tr);
        SServiceProvider.getService((IInternalAccess)this.agent, IDF.class, (String)"platform").addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener<IDF>(){

            public void resultAvailable(IDF df) {
                IDFServiceDescription sd = df.createDFServiceDescription(null, "testType", null);
                IDFComponentDescription ad = df.createDFComponentDescription(null, sd);
                ISearchConstraints cons = df.createSearchConstraints(-1, 0);
                IFuture re = df.search(ad, cons);
                re.addResultListener(((IExecutionFeature)DFTestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<IDFComponentDescription[]>(){

                    public void resultAvailable(IDFComponentDescription[] agentDesc) {
                        if (agentDesc.length != 0) {
                            tr.setSucceeded(true);
                            IComponentIdentifier receiver = agentDesc[0].getName();
                            DFTestAgent.this.sendMessageToReceiver(receiver).addResultListener((IResultListener)new DelegationResultListener(ret));
                        } else {
                            tr.setFailed("No suitable service found.");
                            DFTestAgent.this.agent.killComponent();
                            ret.setResult(null);
                        }
                    }

                    public void exceptionOccurred(Exception e) {
                        tr.setFailed(e.toString());
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    private IFuture<Void> sendMessageToReceiver(IComponentIdentifier cid) {
        final TestReport tr = new TestReport("#3", "Test sending message to service (i.e. myself).");
        this.reports.add(tr);
        HashMap<String, String> hlefMessage = new HashMap<String, String>();
        hlefMessage.put("performative", "inform");
        hlefMessage.put("sender", (String)this.agent.getComponentIdentifier());
        hlefMessage.put("receivers", (String)cid);
        hlefMessage.put("content", "testMessage");
        ((IMessageFeature)this.agent.getComponentFeature(IMessageFeature.class)).sendMessage(hlefMessage, SFipa.FIPA_MESSAGE_TYPE);
        return ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                tr.setFailed("No message received.");
                return IFuture.DONE;
            }
        });
    }

    @AgentMessageArrived
    public void messageArrived(Map<String, Object> msg, MessageType mt) {
        TestReport tr = this.reports.get(this.reports.size() - 1);
        if ("testMessage".equals(msg.get("content"))) {
            tr.setSucceeded(true);
        } else {
            tr.setFailed("Wrong message received: " + msg);
        }
        this.agent.killComponent();
    }
}

