/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.SUtil;
import jadex.commons.future.CollectionResultListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Component;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.AAgent;
import jadex.micro.testcases.BAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Description(value="Test if services of (earlier) sibling components can be found and used.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@ComponentTypes(value={@ComponentType(name="a", clazz=AAgent.class), @ComponentType(name="b", clazz=BAgent.class)})
@Configurations(value={@Configuration(name="def", components={@Component(type="a"), @Component(type="b")})})
@Agent
public class DependendServicesAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentCreated
    public IFuture<Void> agentCreated() {
        final Future ret = new Future();
        this.getChildrenAccesses().addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<Collection<IExternalAccess>, Void>(ret){

            public void customResultAvailable(Collection<IExternalAccess> result) {
                IExternalAccess[] childs = result.toArray(new IExternalAccess[0]);
                System.out.println("childs: " + SUtil.arrayToString((Object)childs));
                final CollectionResultListener lis = new CollectionResultListener(childs.length, true, ((IExecutionFeature)DependendServicesAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Collection<Collection<TestReport>>>(){

                    public void resultAvailable(Collection<Collection<TestReport>> result) {
                        System.out.println("fini: " + result);
                        ArrayList<TestReport> tests = new ArrayList<TestReport>();
                        for (Collection<TestReport> tmp : result) {
                            tests.addAll(tmp);
                        }
                        ((IArgumentsResultsFeature)DependendServicesAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(tests.size(), tests.toArray(new TestReport[tests.size()])));
                        DependendServicesAgent.this.agent.killComponent();
                    }

                    public void exceptionOccurred(Exception exception) {
                        DependendServicesAgent.this.agent.killComponent(exception);
                    }
                }));
                for (int i = 0; i < childs.length; ++i) {
                    final IExternalAccess child = childs[i];
                    child.subscribeToEvents(IMonitoringEvent.TERMINATION_FILTER, false, IMonitoringService.PublishEventLevel.COARSE).addResultListener((IResultListener)new IntermediateDefaultResultListener<IMonitoringEvent>(){

                        public void intermediateResultAvailable(IMonitoringEvent result) {
                            child.getResults().addResultListener(((IExecutionFeature)DependendServicesAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Map<String, Object>>(){

                                public void resultAvailable(Map<String, Object> res) {
                                    System.out.println("del: " + child.getComponentIdentifier() + " " + res);
                                    List tests = (List)res.get("testcases");
                                    lis.resultAvailable((Object)tests);
                                }

                                public void exceptionOccurred(Exception exception) {
                                    lis.exceptionOccurred(exception);
                                }
                            }));
                        }

                        public void exceptionOccurred(Exception exception) {
                            lis.exceptionOccurred(exception);
                        }
                    });
                }
                ret.setResult(null);
            }
        }));
        return ret;
    }

    @AgentBody
    public IFuture<Void> executeBody() {
        this.getChildrenAccesses().addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener<Collection<IExternalAccess>>(){

            public void resultAvailable(Collection<IExternalAccess> result) {
                IExternalAccess[] childs = result.toArray(new IExternalAccess[0]);
                for (int i = 0; i < childs.length; ++i) {
                    childs[i].killComponent();
                }
            }
        }));
        return new Future();
    }

    public IFuture<Collection<IExternalAccess>> getChildrenAccesses() {
        final Future ret = new Future();
        SServiceProvider.getService((IInternalAccess)this.agent, IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Collection<IExternalAccess>>(ret){

            public void customResultAvailable(IComponentManagementService result) {
                final IComponentManagementService cms = result;
                cms.getChildren(DependendServicesAgent.this.agent.getComponentIdentifier()).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier[], Collection<IExternalAccess>>(ret){

                    public void customResultAvailable(IComponentIdentifier[] children) {
                        CollectionResultListener crl = new CollectionResultListener(children.length, true, (IResultListener)new DelegationResultListener(ret));
                        for (int i = 0; !ret.isDone() && i < children.length; ++i) {
                            cms.getExternalAccess(children[i]).addResultListener((IResultListener)crl);
                        }
                    }
                });
            }
        });
        return ret;
    }
}

