/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.SUtil;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Argument;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.Imports;
import jadex.micro.annotation.Properties;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.BaseAgent;
import jadex.micro.testcases.IAService;
import jadex.micro.testcases.ProvidedServiceConfigurationsAgent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

@Agent
@Description(value="Extended base description")
@Imports(value={"eb1", "eb2"})
@Properties(value={@NameValue(name="a", value="\"eba\""), @NameValue(name="b", value="\"ebb\"")})
@RequiredServices(value={@RequiredService(name="clock", type=IClockService.class, binding=@Binding(scope="local"))})
@ProvidedServices(value={@ProvidedService(name="myservice", type=IAService.class, implementation=@Implementation(value=ProvidedServiceConfigurationsAgent.MyAService.class))})
@Arguments(value={@Argument(name="arg1", defaultvalue="\"ebval\"", clazz=String.class)})
@Results(value={@Result(name="res1", defaultvalue="\"ebres\"", clazz=String.class), @Result(name="testresults", clazz=Testcase.class)})
@Configurations(replace=true, value={@Configuration(name="ebconfig1")})
public class ExtendedBaseAgent
extends BaseAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        ArrayList<TestReport> results = new ArrayList<TestReport>();
        TestReport tr = new TestReport("#1", "Test if top-level description is used");
        String desc = this.agent.getModel().getDescription();
        if ("Extended base description".equals(desc)) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong description: " + desc);
        }
        results.add(tr);
        tr = new TestReport("#2", "Test if all imports are used");
        String[] imps = this.agent.getModel().getImports();
        Set impset = SUtil.arrayToSet((Object)imps);
        if (impset.contains("b1") && impset.contains("b2") && impset.contains("eb1") && impset.contains("eb2")) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong import set: " + impset);
        }
        results.add(tr);
        tr = new TestReport("#3", "Test properties");
        Map props = this.agent.getModel().getProperties();
        if (((UnparsedExpression)props.get("a")).getValue().equals("\"eba\"") && ((UnparsedExpression)props.get("b")).getValue().equals("\"ebb\"")) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong properties: " + props);
        }
        results.add(tr);
        tr = new TestReport("#4", "Required services");
        Object[] reqs = this.agent.getModel().getRequiredServices();
        if (reqs[0].getDefaultBinding().getScope().equals("local")) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong required services: " + Arrays.toString(reqs));
        }
        results.add(tr);
        tr = new TestReport("#5", "Provided services");
        ProvidedServiceInfo[] provs = this.agent.getModel().getProvidedServices();
        if (provs[0].getImplementation().getClazz().getType(this.agent.getClassLoader()).equals(ProvidedServiceConfigurationsAgent.MyAService.class)) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong arguments: " + Arrays.toString(reqs));
        }
        results.add(tr);
        tr = new TestReport("#6", "Arguments");
        Object[] args = this.agent.getModel().getArguments();
        if (args[0].getDefaultValue().getValue().equals("\"ebval\"")) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong arguments: " + Arrays.toString(args));
        }
        results.add(tr);
        tr = new TestReport("#7", "Results");
        Object[] res = this.agent.getModel().getResults();
        if (res[0].getDefaultValue().getValue().equals("\"ebres\"")) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong results: " + Arrays.toString(res));
        }
        results.add(tr);
        tr = new TestReport("#8", "Configurations");
        Object[] configs = this.agent.getModel().getConfigurations();
        if (configs.length == 1) {
            tr.setSucceeded(true);
        } else {
            tr.setReason("Wrong configurations: " + Arrays.toString(configs));
        }
        results.add(tr);
        ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(results.size(), results.toArray(new TestReport[results.size()])));
        this.agent.killComponent();
    }
}

