/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.Value;
import jadex.bridge.service.component.IProvidedServicesFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.IAService;
import jadex.micro.testcases.SimpleInterceptor;
import java.util.ArrayList;
import java.util.List;

@Description(value="Testing if required services can be equipped with interceptors.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@ProvidedServices(value={@ProvidedService(name="aservice", type=IAService.class, implementation=@Implementation(expression="$pojoagent", interceptors={@Value(value="$pojoagent.provinter")}))})
@RequiredServices(value={@RequiredService(name="aservice", type=IAService.class, binding=@Binding(scope="local", interceptors={@Value(value="$pojoagent.reqinter")}))})
@Service(value=IAService.class)
@Agent
public class InterceptorAgent
implements IAService {
    @Agent
    protected IInternalAccess agent;
    public SimpleInterceptor provinter = new SimpleInterceptor();
    public SimpleInterceptor reqinter = new SimpleInterceptor();

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final ArrayList<TestReport> testresults = new ArrayList<TestReport>();
        this.performProvidedServiceTest(testresults).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                InterceptorAgent.this.performRequiredServiceTest(testresults).addResultListener(((IExecutionFeature)InterceptorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<Void>(ret){

                    public void customResultAvailable(Void result) {
                        TestReport[] tr = testresults.toArray(new TestReport[testresults.size()]);
                        ((IArgumentsResultsFeature)InterceptorAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(tr.length, tr));
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    public IFuture<Void> performProvidedServiceTest(final List<TestReport> testresults) {
        final Future ret = new Future();
        IAService ser = (IAService)((IProvidedServicesFeature)this.agent.getComponentFeature(IProvidedServicesFeature.class)).getProvidedService("aservice");
        ser.test().addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

            public void customResultAvailable(Void result) {
                TestReport tr = new TestReport("#1", "Provided service test.");
                if (InterceptorAgent.this.provinter.getCnt() == 1) {
                    tr.setSucceeded(true);
                } else {
                    tr.setReason("Wrong interceptor count: " + InterceptorAgent.this.provinter.getCnt());
                }
                testresults.add(tr);
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture<Void> performRequiredServiceTest(final List<TestReport> testresults) {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("aservice").addResultListener((IResultListener)new DefaultResultListener<Object>(){

            public void resultAvailable(Object result) {
                IAService ser = (IAService)result;
                ser.test().addResultListener((IResultListener)new DefaultResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        TestReport tr = new TestReport("#2", "Required service test.");
                        if (InterceptorAgent.this.reqinter.getCnt() == 1) {
                            tr.setSucceeded(true);
                        } else {
                            tr.setReason("Wrong interceptor count: " + InterceptorAgent.this.reqinter.getCnt());
                        }
                        testresults.add(tr);
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    @Override
    public IFuture<Void> test() {
        return IFuture.DONE;
    }
}

