/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.Starter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;

@Agent
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
public class KillAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentCreated
    public IFuture<Void> body() {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                cms.createComponent(null, "jadex.micro.MicroAgent.class", new CreationInfo(KillAgent.this.agent.getComponentIdentifier()), null).addResultListener(((IExecutionFeature)KillAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<IComponentIdentifier>(){

                    public void resultAvailable(IComponentIdentifier result) {
                        System.out.println("Micro agent started: " + result);
                    }

                    public void exceptionOccurred(Exception exception) {
                    }
                }));
                ret.setResult(null);
                KillAgent.this.agent.killComponent();
            }
        });
        return ret;
    }

    public static void main(String[] args) {
        IExternalAccess pl = (IExternalAccess)Starter.createPlatform((String[])new String[]{"-gui", "false", "-autoshutdown", "false"}).get();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getService((IExternalAccess)pl, IComponentManagementService.class, (String)"platform").get();
        for (int i = 0; i < 1000; ++i) {
            IComponentIdentifier cid = (IComponentIdentifier)cms.createComponent(KillAgent.class.getName() + ".class", null).getFirstResult();
            try {
                cms.destroyComponent(cid).get();
                continue;
            }
            catch (Exception e) {
                System.out.println("Ex: " + e.getMessage());
            }
        }
        try {
            Thread.currentThread();
            Thread.sleep(30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("fini");
    }
}

