/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.clock.IClockService;
import jadex.commons.SUtil;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Imports;
import jadex.micro.annotation.Properties;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@Imports(value={"java.util.logging.*"})
@Description(value="Tests the logger.")
@Results(value={@Result(name="testresults", description="The test results.", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="clockservice", type=IClockService.class, binding=@Binding(scope="global"))})
@Properties(value={@NameValue(name="logging.level", value="Level.FINEST"), @NameValue(name="logging.handlers", clazz=TestLogHandler.class)})
@Agent
public class LoggerAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clockservice").addResultListener((IResultListener)new ExceptionDelegationResultListener<Object, Void>(ret){

            public void customResultAvailable(Object result) {
                final IClockService clock = (IClockService)result;
                final long start = clock.getTime();
                String ct = clock.getClockType();
                final boolean simclock = "event_driven".equals(ct) || "time_driven".equals(ct);
                ArrayList<TestReport> reports = new ArrayList<TestReport>();
                final TestReport tr = new TestReport("#1", "Test logging.");
                LoggerAgent.this.agent.getLogger().setLevel(Level.FINEST);
                LoggerAgent.this.agent.getLogger().addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord record) {
                        long end = clock.getTime();
                        long diff = end - start;
                        if (simclock && diff == 0L || !simclock && diff < 1000L) {
                            tr.setSucceeded(true);
                        } else {
                            tr.setReason("Time in log record differs substantially: " + end + " " + start + " " + diff);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                });
                reports.add(tr);
                LoggerAgent.this.agent.getLogger().info("test log message");
                TestReport tr2 = new TestReport("#2", "Test logging handler.");
                Handler[] handlers = LoggerAgent.this.agent.getLogger().getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    if (!(handlers[i] instanceof TestLogHandler)) continue;
                    tr2.setSucceeded(true);
                    break;
                }
                if (!tr2.isSucceeded()) {
                    tr2.setReason("TestLogHandler was not found: " + SUtil.arrayToString((Object)handlers));
                }
                reports.add(tr2);
                ((IArgumentsResultsFeature)LoggerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(reports.size(), reports.toArray(new TestReport[reports.size()])));
                ret.setResult(null);
            }
        });
        return ret;
    }

    public static class TestLogHandler
    extends Handler {
        @Override
        public void publish(LogRecord record) {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }
    }
}

