/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.IService;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.Collection;

@Description(value="Test searching for services that don't exist.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Agent
public class NoServiceAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#1", "Searching for services.");
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchServices(INoService.class).addResultListener((IResultListener)new IResultListener<Collection<INoService>>(){

            public void resultAvailable(Collection<INoService> result) {
                if (result.isEmpty()) {
                    tr.setSucceeded(true);
                } else {
                    tr.setFailed("Expected empty collection but was: " + result);
                }
                ((IArgumentsResultsFeature)NoServiceAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                ret.setResult(null);
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed("Exception during test: " + exception);
                ((IArgumentsResultsFeature)NoServiceAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                ret.setResult(null);
            }
        });
        return ret;
    }

    public static interface INoService
    extends IService {
    }
}

