/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.ServiceInvalidException;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.ServiceNotFoundException;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.servicecall.DecoupledServiceAgent;
import jadex.micro.servicecall.DirectServiceAgent;
import jadex.micro.servicecall.IServiceCallService;
import jadex.micro.servicecall.RawServiceAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

@Description(value="A test case for testing access to services of already terminated components.")
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
@Agent
public class RemovedServiceAgent {
    @Agent
    protected IInternalAccess agent;
    @AgentService
    protected IComponentManagementService cms;
    protected int cnt;

    @AgentBody
    public IFuture<Void> body() {
        final Future reports = new Future();
        this.performTests(RawServiceAgent.class.getName() + ".class", true).addResultListener((IResultListener)new DelegationResultListener<Collection<TestReport>>(reports){

            public void customResultAvailable(final Collection<TestReport> reports1) {
                RemovedServiceAgent.this.performTests(DirectServiceAgent.class.getName() + ".class", true).addResultListener((IResultListener)new DelegationResultListener<Collection<TestReport>>(reports){

                    public void customResultAvailable(final Collection<TestReport> reports2) {
                        RemovedServiceAgent.this.performTests(DecoupledServiceAgent.class.getName() + ".class", false).addResultListener((IResultListener)new DelegationResultListener<Collection<TestReport>>(reports){

                            public void customResultAvailable(Collection<TestReport> reports3) {
                                ArrayList<TestReport> result = new ArrayList<TestReport>();
                                result.addAll(reports1);
                                result.addAll(reports2);
                                result.addAll(reports3);
                                super.customResultAvailable(result);
                            }
                        });
                    }
                });
            }
        });
        final Future ret = new Future();
        reports.addResultListener((IResultListener)new IResultListener<Collection<TestReport>>(){

            public void resultAvailable(Collection<TestReport> results) {
                ((IArgumentsResultsFeature)RemovedServiceAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(results.size(), results.toArray(new TestReport[results.size()])));
                ret.setResult(null);
            }

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#1", "Exception during test.");
                tr.setFailed(exception.toString());
                ((IArgumentsResultsFeature)RemovedServiceAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                ret.setResult(null);
            }
        });
        return ret;
    }

    public IFuture<Collection<TestReport>> performTests(final String agentname, final boolean callsuccess) {
        final IntermediateFuture testfut = new IntermediateFuture();
        this.cms.createComponent(null, agentname, new CreationInfo(this.agent.getComponentIdentifier()), null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Collection<TestReport>>((Future)testfut){

            public void customResultAvailable(final IComponentIdentifier cid) {
                ((IRequiredServicesFeature)RemovedServiceAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IServiceCallService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IServiceCallService, Collection<TestReport>>((Future)testfut){

                    public void customResultAvailable(final IServiceCallService scs) {
                        final TestReport tr1 = new TestReport("#" + ++RemovedServiceAgent.this.cnt, "Test if service of " + agentname + " can be called.");
                        testfut.addIntermediateResult((Object)tr1);
                        scs.call().addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, Collection<TestReport>>((Future)testfut){

                            public void customResultAvailable(Void result) {
                                tr1.setSucceeded(true);
                                RemovedServiceAgent.this.cms.destroyComponent(cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<Map<String, Object>, Collection<TestReport>>((Future)testfut){

                                    public void customResultAvailable(Map<String, Object> result) {
                                        final TestReport tr2 = new TestReport("#" + ++RemovedServiceAgent.this.cnt, "Test if service of destroyed " + agentname + " can be found.");
                                        testfut.addIntermediateResult((Object)tr2);
                                        ((IRequiredServicesFeature)RemovedServiceAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IServiceCallService.class, "platform").addResultListener((IResultListener)new IResultListener<IServiceCallService>(){

                                            public void resultAvailable(IServiceCallService result) {
                                                tr2.setFailed("Service was found: " + result);
                                                this.cont();
                                            }

                                            public void exceptionOccurred(Exception exception) {
                                                if (exception instanceof ServiceNotFoundException || exception instanceof ComponentTerminatedException) {
                                                    tr2.setSucceeded(true);
                                                } else {
                                                    tr2.setFailed("Wrong exception. Expected ServiceNotFoundException but was: " + exception);
                                                }
                                                this.cont();
                                            }

                                            protected void cont() {
                                                final TestReport tr3 = new TestReport("#" + ++RemovedServiceAgent.this.cnt, "Test if service of destroyed " + agentname + " can be called.");
                                                testfut.addIntermediateResult((Object)tr3);
                                                scs.call().addResultListener((IResultListener)new IResultListener<Void>(){

                                                    public void exceptionOccurred(Exception exception) {
                                                        this.cont(exception);
                                                    }

                                                    public void resultAvailable(Void result) {
                                                        this.cont(null);
                                                    }

                                                    protected void cont(Exception ex) {
                                                        if (callsuccess) {
                                                            if (ex == null) {
                                                                tr3.setSucceeded(true);
                                                            } else {
                                                                tr3.setFailed("Service call did not succeed: " + ex);
                                                            }
                                                        } else if (ex == null) {
                                                            tr3.setFailed("Service call did not fail as expected.");
                                                        } else if (ex instanceof ServiceInvalidException || ex instanceof ComponentTerminatedException) {
                                                            tr3.setSucceeded(true);
                                                        } else {
                                                            tr3.setFailed("Wrong exception. Expected ServiceInvalidException but was: " + ex);
                                                        }
                                                        ((IArgumentsResultsFeature)RemovedServiceAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(3, new TestReport[]{tr1, tr2, tr3}));
                                                        testfut.setFinished();
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
        return testfut;
    }
}

