/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.clock.ITimedObject;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.message.IMessageService;
import jadex.commons.Tuple2;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentKilled;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@Agent
@RequiredServices(value={@RequiredService(name="msgservice", type=IMessageService.class, binding=@Binding(scope="platform")), @RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform")), @RequiredService(name="clock", type=IClockService.class, binding=@Binding(scope="platform"))})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public abstract class TestAgent {
    @Agent
    protected IInternalAccess agent;
    protected Set<IExternalAccess> platforms = new LinkedHashSet<IExternalAccess>();

    @AgentKilled
    public IFuture<Void> cleanup() {
        Future ret = new Future();
        CounterResultListener crl = new CounterResultListener(this.platforms.size(), (IResultListener)new DelegationResultListener(ret));
        for (IExternalAccess platform : this.platforms) {
            platform.killComponent().addResultListener((IResultListener)crl);
        }
        this.platforms = null;
        return ret;
    }

    @AgentBody
    public IFuture<Void> body() {
        final Future ret = new Future();
        final Testcase tc = new Testcase();
        tc.setTestCount(this.getTestCount());
        this.performTests(tc).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                ((IArgumentsResultsFeature)TestAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                ret.setResult(null);
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                ((IArgumentsResultsFeature)TestAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                ret.setResult(null);
            }
        }));
        return ret;
    }

    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                TestAgent.this.test(cms, true).addResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                    public void customResultAvailable(TestReport result) {
                        tc.addReport(result);
                        TestAgent.this.setupRemotePlatform(false).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Void>(ret){

                            public void customResultAvailable(IExternalAccess exta) {
                                SServiceProvider.getService((IExternalAccess)exta, IComponentManagementService.class).addResultListener(((IExecutionFeature)TestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

                                    public void customResultAvailable(IComponentManagementService cms2) {
                                        TestAgent.this.test(cms2, false).addResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                                            public void customResultAvailable(TestReport result) {
                                                tc.addReport(result);
                                                ret.setResult(null);
                                            }
                                        });
                                    }
                                }));
                            }
                        });
                    }
                });
            }
        });
        return ret;
    }

    protected int getTestCount() {
        return 2;
    }

    protected IFuture<IExternalAccess> createPlatform(final String[] args) {
        final Future ret = new Future();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getLocalService((IInternalAccess)this.agent, IComponentManagementService.class, (String)"platform");
        cms.getExternalAccess(this.agent.getComponentIdentifier().getRoot()).addResultListener((IResultListener)new DelegationResultListener<IExternalAccess>(ret){

            public void customResultAvailable(IExternalAccess root) {
                root.getArguments().addResultListener((IResultListener)new ExceptionDelegationResultListener<Map<String, Object>, IExternalAccess>(ret){

                    public void customResultAvailable(Map<String, Object> rootargs) {
                        int i;
                        HashMap<String, String> argsmap = new HashMap<String, String>();
                        String[] progargs = (String[])rootargs.get("programarguments");
                        String[] defargs = new String[]{"-platformname", TestAgent.this.agent.getComponentIdentifier().getPlatformPrefix() + "_*", "-saveonexit", "false", "-welcome", "false", "-autoshutdown", "false", "-awareness", "false", "-gui", "false", "-cli", "false", "-simulation", "false", "-printpass", "false"};
                        for (i = 0; progargs != null && i < progargs.length; ++i) {
                            argsmap.put(progargs[i], progargs[++i]);
                        }
                        for (i = 0; i < defargs.length; ++i) {
                            argsmap.put(defargs[i], defargs[++i]);
                        }
                        for (i = 0; args != null && i < args.length; ++i) {
                            argsmap.put(args[i], args[++i]);
                        }
                        defargs = new String[argsmap.size() * 2];
                        i = 0;
                        Iterator iterator = argsmap.keySet().iterator();
                        while (iterator.hasNext()) {
                            String key;
                            defargs[i * 2] = key = (String)iterator.next();
                            defargs[i * 2 + 1] = (String)argsmap.get(key);
                            ++i;
                        }
                        Starter.createPlatform((String[])defargs).addResultListener(((IExecutionFeature)TestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<IExternalAccess>(ret){

                            public void customResultAvailable(IExternalAccess result) {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                TestAgent.this.platforms.add(result);
                                super.customResultAvailable((Object)result);
                            }
                        }));
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<IComponentIdentifier> createComponent(String filename, IComponentIdentifier root, IResultListener<Collection<Tuple2<String, Object>>> reslis) {
        return this.createComponent(filename, null, null, root, reslis);
    }

    protected IFuture<IComponentIdentifier> createComponent(final String filename, final Map<String, Object> args, final String config, final IComponentIdentifier root, final IResultListener<Collection<Tuple2<String, Object>>> reslis) {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, IComponentIdentifier>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                boolean local = root.equals(TestAgent.this.agent.getComponentIdentifier().getRoot());
                CreationInfo ci = new CreationInfo(local ? TestAgent.this.agent.getComponentIdentifier() : root, TestAgent.this.agent.getModel().getResourceIdentifier());
                ci.setArguments(args);
                ci.setConfiguration(config);
                cms.createComponent(null, filename, ci, reslis).addResultListener((IResultListener)new DelegationResultListener<IComponentIdentifier>(ret){

                    public void customResultAvailable(IComponentIdentifier result) {
                        super.customResultAvailable((Object)result);
                    }

                    public void exceptionOccurred(Exception exception) {
                        exception.printStackTrace();
                        super.exceptionOccurred(exception);
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<Map<String, Object>> destroyComponent(final IComponentIdentifier cid) {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Map<String, Object>>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                cms.destroyComponent(cid).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return ret;
    }

    protected IFuture<IComponentIdentifier> setupLocalTest(String filename, IResultListener<Collection<Tuple2<String, Object>>> reslis) {
        return this.createComponent(filename, this.agent.getComponentIdentifier().getRoot(), reslis);
    }

    protected IFuture<IComponentIdentifier> setupRemoteTest(final String filename, final String config, final IResultListener<Collection<Tuple2<String, Object>>> reslis, boolean remove) {
        final Future ret = new Future();
        this.setupRemotePlatform(remove).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, IComponentIdentifier>(ret){

            public void customResultAvailable(IExternalAccess exta) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)exta).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, IComponentIdentifier>(ret){

                    public void customResultAvailable(ITransportComponentIdentifier cid) {
                        TestAgent.this.createComponent(filename, null, config, (IComponentIdentifier)cid, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new DelegationResultListener(ret));
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<IExternalAccess> setupRemotePlatform(final boolean manualremove) {
        final Future ret = new Future();
        this.createPlatform(null).addResultListener((IResultListener)new DelegationResultListener<IExternalAccess>(ret){

            public void customResultAvailable(final IExternalAccess exta) {
                if (manualremove) {
                    TestAgent.this.platforms.remove(exta);
                }
                Starter.createProxy((IExternalAccess)TestAgent.this.agent.getExternalAccess(), (IExternalAccess)exta).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, IExternalAccess>(ret){

                    public void customResultAvailable(IComponentIdentifier result) {
                        Starter.createProxy((IExternalAccess)exta, (IExternalAccess)TestAgent.this.agent.getExternalAccess()).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, IExternalAccess>(ret){

                            public void customResultAvailable(IComponentIdentifier result) {
                                ret.setResult((Object)exta);
                            }
                        });
                    }
                });
            }
        });
        return ret;
    }

    public <T> IFuture<T> waitForRealtimeDelay(final long delay, final IComponentStep<T> step) {
        final Future ret = new Future();
        IFuture clockfut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("clock");
        clockfut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IClockService, T>(ret){

            public void customResultAvailable(IClockService clock) {
                clock.createRealtimeTimer(delay, new ITimedObject(){

                    public void timeEventOccurred(long currenttime) {
                        ((IExecutionFeature)TestAgent.this.agent.getComponentFeature(IExecutionFeature.class)).scheduleStep(step).addResultListener((IResultListener)new DelegationResultListener(ret));
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<TestReport> test(IComponentManagementService cms, boolean local) {
        throw new UnsupportedOperationException("Implement test() or performTests()");
    }
}

