/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.DefaultTuple2ResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITuple2Future;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.InjectedResultsAgent;
import java.util.Map;

@Agent
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public class TestInjectedResultsAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> executeBody() {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#1", "Test if injected results work.");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                ITuple2Future fut = cms.createComponent(InjectedResultsAgent.class.getName() + ".class", new CreationInfo(TestInjectedResultsAgent.this.agent.getComponentIdentifier()));
                fut.addResultListener((IResultListener)new DefaultTuple2ResultListener<IComponentIdentifier, Map<String, Object>>(){

                    public void firstResultAvailable(IComponentIdentifier result) {
                    }

                    public void secondResultAvailable(Map<String, Object> result) {
                        Object myres = result.get("myres");
                        Object myint = result.get("myint");
                        if ("def_val".equals(myres) && Integer.valueOf(99).equals(myint)) {
                            tr.setSucceeded(true);
                        } else {
                            tr.setFailed("Wrong result values: myres=" + myres + ", myint=" + myint);
                        }
                        ((IArgumentsResultsFeature)TestInjectedResultsAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                        ret.setResult(null);
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr.setFailed("Exception occurred: " + exception);
                        ((IArgumentsResultsFeature)TestInjectedResultsAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(1, new TestReport[]{tr}));
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }
}

