/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.authenticate;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.IService;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.authenticate.ITestService;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, multiple=true, binding=@Binding(scope="global"))})
public class CallAllServicesAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> body() {
        Future ret = new Future();
        ITerminableIntermediateFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("ts");
        fut.addResultListener((IResultListener)new IIntermediateResultListener<ITestService>(){

            public void intermediateResultAvailable(final ITestService ts) {
                System.out.println("found: " + ts);
                ts.method("test1").addResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        System.out.println("called: " + ((IService)ts).getServiceIdentifier());
                    }

                    public void exceptionOccurred(Exception exception) {
                        System.out.println("exception calling: " + ((IService)ts).getServiceIdentifier() + " " + exception);
                    }
                });
            }

            public void finished() {
                System.out.println("Finished");
            }

            public void resultAvailable(Collection<ITestService> result) {
                for (ITestService ts : result) {
                    this.intermediateResultAvailable(ts);
                }
                this.finished();
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
            }
        });
        return ret;
    }
}

