/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.authenticate;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.security.ISecurityService;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.authenticate.ITestService;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global"))})
public class InitiatorAgent
extends TestAgent {
    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                InitiatorAgent.this.testRemote(2).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                    public void customResultAvailable(TestReport result) {
                        tc.addReport(result);
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testLocal(final int testno) {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ISecurityService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<ISecurityService, TestReport>(ret){

            public void customResultAvailable(final ISecurityService sec) {
                sec.addVirtual("testuser", InitiatorAgent.this.agent.getComponentIdentifier().getPlatformPrefix()).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

                    public void customResultAvailable(Void result) {
                        InitiatorAgent.this.performTest(InitiatorAgent.this.agent.getComponentIdentifier().getRoot(), testno).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

                            public void customResultAvailable(final TestReport result) {
                                sec.removeVirtual("testuser", InitiatorAgent.this.agent.getComponentIdentifier().getPlatformPrefix()).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, TestReport>(ret){

                                    public void customResultAvailable(Void v) throws Exception {
                                        ret.setResult((Object)result);
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<TestReport> testRemote(final int testno) {
        final Future ret = new Future();
        this.createPlatform(new String[]{"-virtualnames", "jadex.commons.SUtil.createHashMap(new String[]{\"testuser\"}, new Object[]{jadex.commons.SUtil.createHashSet(new String[]{\"testcases\"})})"}).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport>(ret){

                    public void customResultAvailable(ITransportComponentIdentifier cid) {
                        InitiatorAgent.this.performTest((IComponentIdentifier)cid, testno).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }
                });
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> performTest(IComponentIdentifier root, final int testno) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if authentication works.");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent("jadex/micro/testcases/authenticate/ProviderAgent.class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

            public void customResultAvailable(IComponentIdentifier cid) {
                InitiatorAgent.this.callService(cid, testno).addResultListener((IResultListener)new DelegationResultListener(ret));
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                super.exceptionOccurred(exception);
            }
        });
        return res;
    }

    protected IFuture<TestReport> callService(IComponentIdentifier cid, int testno) {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Test if authentication works.");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ITestService.class, cid);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<ITestService, TestReport>(ret){

            public void customResultAvailable(ITestService ts) {
                ts.method("test1").addResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        tr.setSucceeded(true);
                        ret.setResult((Object)tr);
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr.setFailed("Exception occurred: " + exception);
                        ret.setResult((Object)tr);
                    }
                });
            }
        });
        return ret;
    }
}

