/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.autoterminate;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.service.annotation.Service;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.commons.future.TerminationCommand;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.autoterminate.IAutoTerminateService;
import jadex.micro.testcases.autoterminate.SubscriberAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
@Agent
@ProvidedServices(value={@ProvidedService(type=IAutoTerminateService.class)})
public class AutoTerminateAgent
extends TestAgent
implements IAutoTerminateService {
    protected List<TestReport> reports = new ArrayList<TestReport>();
    @Agent
    protected IInternalAccess agent;
    protected Future<Void> ret;
    protected Testcase tc;

    @Override
    protected IFuture<Void> performTests(Testcase tc) {
        this.ret = new Future();
        this.tc = tc;
        if (SReflect.isAndroid()) {
            tc.setTestCount(1);
        } else {
            tc.setTestCount(3);
        }
        this.setupLocalTest(SubscriberAgent.class.getName() + ".class", null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Void>(this.ret){

            public void customResultAvailable(IComponentIdentifier result) {
                if (!SReflect.isAndroid()) {
                    AutoTerminateAgent.this.setupRemoteTest(SubscriberAgent.class.getName() + ".class", "self", (IResultListener<Collection<Tuple2<String, Object>>>)null, false).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Void>(AutoTerminateAgent.this.ret){

                        public void customResultAvailable(IComponentIdentifier result) {
                            AutoTerminateAgent.this.setupRemoteTest(SubscriberAgent.class.getName() + ".class", "platform", (IResultListener<Collection<Tuple2<String, Object>>>)null, true);
                        }
                    });
                }
            }
        });
        return this.ret;
    }

    @Override
    public ISubscriptionIntermediateFuture<String> subscribe() {
        final TestReport report = new TestReport("#" + this.reports.size() + 1, this.reports.size() == 0 ? "Test local automatic subscription termination: " + ServiceCall.getCurrentInvocation().getCaller() : (this.reports.size() == 1 ? "Test remote automatic subscription termination: " + ServiceCall.getCurrentInvocation().getCaller() : "Test remote offline automatic subscription termination: " + ServiceCall.getCurrentInvocation().getCaller()));
        this.reports.add(report);
        this.waitForRealtimeDelay(Starter.getLocalDefaultTimeout((IComponentIdentifier)this.agent.getComponentIdentifier()), new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                if (!report.isSucceeded()) {
                    report.setFailed("Termination did not happen.");
                    AutoTerminateAgent.this.checkFinished();
                }
                return IFuture.DONE;
            }
        });
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture((ITerminationCommand)new TerminationCommand(){

            public void terminated(Exception reason) {
                if (report.getReason() == null) {
                    report.setSucceeded(true);
                    AutoTerminateAgent.this.checkFinished();
                } else {
                    report.setFailed(reason.getMessage());
                }
            }
        });
        this.waitForRealtimeDelay(1000L, new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                if (ret.addIntermediateResultIfUndone((Object)"ping")) {
                    AutoTerminateAgent.this.waitForRealtimeDelay(1000L, this);
                }
                return IFuture.DONE;
            }
        });
        return ret;
    }

    protected void checkFinished() {
        boolean finished = false;
        if (SReflect.isAndroid()) {
            finished = this.reports.size() == 1 && this.reports.get(0).isFinished();
        } else {
            boolean bl = finished = this.reports.size() == 3 && this.reports.get(0).isFinished() && this.reports.get(1).isFinished() && this.reports.get(2).isFinished();
        }
        if (finished) {
            this.tc.setReports(this.reports.toArray(new TestReport[this.reports.size()]));
            this.ret.setResult(null);
        }
    }
}

