/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.blocking;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.commons.Boolean3;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import java.util.ArrayList;
import java.util.List;

@Agent(keepalive=Boolean3.FALSE)
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
public class BlockingTimeoutTestAgent {
    @AgentBody
    public void execute(IInternalAccess agent) {
        ArrayList<TestReport> tests = new ArrayList<TestReport>();
        this.runTests(agent, tests);
        this.runTests(agent, tests);
        ((IArgumentsResultsFeature)agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(tests.size(), tests.toArray(new TestReport[tests.size()])));
    }

    public void runTests(IInternalAccess agent, List<TestReport> tests) {
        final Future fut = new Future();
        ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(250L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                fut.setResult((Object)"dummy");
                return IFuture.DONE;
            }
        });
        fut.get(500L);
        final Future fut2 = new Future();
        ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(250L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                fut2.setResult((Object)"dummy");
                return IFuture.DONE;
            }
        });
        fut2.get(500L);
        ((IExecutionFeature)agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L).get();
        tests.add(new TestReport("#1", "Test if unused timeout timer entries are ignored.", true, null));
        TestReport tr = new TestReport("#2", "Test if wake up after timeout works.");
        try {
            new Future().get(500L);
            tr.setFailed("No timeout exception");
        }
        catch (TimeoutException te) {
            tr.setSucceeded(true);
        }
        tests.add(tr);
        tr = new TestReport("#3", "Test if wake up after timeout works again.");
        try {
            new Future().get(500L);
            tr.setFailed("No timeout exception");
        }
        catch (TimeoutException te) {
            tr.setSucceeded(true);
        }
        tests.add(tr);
    }
}

