/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.blocking;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.Boolean3;
import jadex.commons.future.IFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.blocking.IBlockService;
import jadex.micro.testcases.blocking.IStepService;

@Agent(keepalive=Boolean3.FALSE)
@Service
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@ProvidedServices(value={@ProvidedService(type=IBlockService.class)})
@RequiredServices(value={@RequiredService(name="myser", type=IBlockService.class, binding=@Binding(scope="local")), @RequiredService(name="stepser", type=IStepService.class, binding=@Binding(scope="global"))})
public class ReqServiceBlockAgent
implements IBlockService {
    @AgentBody
    public void execute(IInternalAccess agent) {
        TestReport[] trs = new TestReport[2];
        trs[0] = new TestReport("#1", "Test if required service can be fetched with get()");
        try {
            IBlockService bs = (IBlockService)((IRequiredServicesFeature)agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("myser").get(1000L);
            trs[0].setSucceeded(true);
        }
        catch (Exception e) {
            trs[0].setFailed("Exception occurred: " + e.getMessage());
            e.printStackTrace();
        }
        trs[1] = new TestReport("#2", "Test if not available required service can be fetched with get()");
        try {
            IStepService ss = (IStepService)((IRequiredServicesFeature)agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("stepser").get(10L);
            trs[1].setFailed("Non-available service found: " + ss.toString());
        }
        catch (Exception e) {
            trs[1].setSucceeded(true);
        }
        ((IArgumentsResultsFeature)agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(2, trs));
    }

    @Override
    public IFuture<Void> block(long millis) {
        return IFuture.DONE;
    }
}

