/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.blocking;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SReflect;
import jadex.commons.future.DefaultTuple2ResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.blocking.BlockAgent;
import jadex.micro.testcases.blocking.IBlockService;
import java.util.Map;

@Agent
@Service
@ComponentTypes(value={@ComponentType(name="block", clazz=BlockAgent.class)})
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform"))})
public class ShutdownAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> body() {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Void>(ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                cms.createComponent(BlockAgent.class.getName() + ".class", new CreationInfo(ShutdownAgent.this.agent.getComponentIdentifier())).addResultListener((IResultListener)new DefaultTuple2ResultListener<IComponentIdentifier, Map<String, Object>>(){

                    public void firstResultAvailable(final IComponentIdentifier cid) {
                        ((IRequiredServicesFeature)ShutdownAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IBlockService.class, cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<IBlockService, Void>(ret){

                            public void customResultAvailable(IBlockService bs) {
                                int numBlocks = 1000;
                                if (SReflect.isAndroid()) {
                                    numBlocks = 100;
                                }
                                for (int i = 0; i < numBlocks; ++i) {
                                    bs.block(-1L);
                                }
                                ((IExecutionFeature)ShutdownAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L).addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

                                    public void customResultAvailable(Void result) {
                                        cms.destroyComponent(cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<Map<String, Object>, Void>(ret){

                                            public void customResultAvailable(Map<String, Object> result) {
                                                System.out.println("fini1: " + result);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }

                    public void secondResultAvailable(Map<String, Object> result) {
                        System.out.println("fini2: " + result);
                        ShutdownAgent.this.agent.killComponent();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setException(exception);
                    }
                });
            }
        });
        return ret;
    }
}

