/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.blocking;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.blocking.IBlockService;
import jadex.micro.testcases.blocking.IStepService;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=IStepService.class, implementation=@Implementation(expression="$pojoagent"))})
@RequiredServices(value={@RequiredService(name="block", type=IBlockService.class)})
public class StepAgent
implements IStepService {
    @Agent
    protected IInternalAccess agent;
    @AgentService
    protected IBlockService block;

    @Override
    public IIntermediateFuture<Integer> performSteps(final int steps, final long millis) {
        final IntermediateFuture ret = new IntermediateFuture();
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(0L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                for (int i = 1; i <= steps; ++i) {
                    ((IExecutionFeature)ia.getComponentFeature(IExecutionFeature.class)).waitForDelay(millis).get();
                    ret.addIntermediateResult((Object)i);
                }
                ret.setFinished();
                return IFuture.DONE;
            }
        });
        return ret;
    }

    @Override
    public ISubscriptionIntermediateFuture<Integer> subscribeToSteps(final long millis) {
        final SubscriptionIntermediateFuture ret = new SubscriptionIntermediateFuture();
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(0L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                int i = 1;
                while (!ret.isDone()) {
                    ((IExecutionFeature)ia.getComponentFeature(IExecutionFeature.class)).waitForDelay(millis).get();
                    ret.addIntermediateResult((Object)i);
                    ++i;
                }
                return IFuture.DONE;
            }
        });
        return ret;
    }
}

