/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.intermediate;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ILocalResourceIdentifier;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.LocalResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.intermediate.IIntermediateResultService;
import java.util.Collection;

@Agent
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Description(value="The invoker agent tests if intermediate results are directly delivered back to the invoker in local and remote case.")
public class InvokerAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        final Testcase tc = new Testcase();
        if (SReflect.isAndroid()) {
            tc.setTestCount(1);
        } else {
            tc.setTestCount(2);
        }
        final Future ret = new Future();
        ret.addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<TestReport>(){

            public void resultAvailable(TestReport result) {
                ((IArgumentsResultsFeature)InvokerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                InvokerAgent.this.agent.killComponent();
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).isComponentThread() + " " + InvokerAgent.this.agent.getComponentIdentifier());
                ((IArgumentsResultsFeature)InvokerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                InvokerAgent.this.agent.killComponent();
            }
        }));
        this.testLocal(1, 100L, 3).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                if (SReflect.isAndroid()) {
                    ret.setResult(null);
                } else {
                    InvokerAgent.this.testRemote(2, 100L, 3).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

                        public void customResultAvailable(TestReport result) {
                            tc.addReport(result);
                            ret.setResult(null);
                        }
                    }));
                }
            }
        }));
    }

    protected IFuture<TestReport> testLocal(int testno, long delay, int max) {
        return this.performTest(this.agent.getComponentIdentifier().getRoot(), testno, delay, max);
    }

    protected IFuture<TestReport> testRemote(final int testno, final long delay, final int max) {
        final Future ret = new Future();
        try {
            String url = SUtil.getOutputDirsExpression((String)"jadex-applications-micro");
            Starter.createPlatform((String[])new String[]{"-libpath", url, "-platformname", this.agent.getComponentIdentifier().getPlatformPrefix() + "_*", "-saveonexit", "false", "-welcome", "false", "-autoshutdown", "false", "-awareness", "false", "-gui", "false", "-simulation", "false", "-printpass", "false"}).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

                public void customResultAvailable(final IExternalAccess platform) {
                    ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport>(ret){

                        public void customResultAvailable(ITransportComponentIdentifier result) {
                            InvokerAgent.this.performTest((IComponentIdentifier)result, testno, delay, max).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

                                public void customResultAvailable(TestReport result) {
                                    platform.killComponent();
                                    ret.setResult((Object)result);
                                }
                            }));
                        }
                    });
                }
            }));
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }

    protected IFuture<TestReport> performTest(final IComponentIdentifier root, final int testno, final long delay, final int max) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, TestReport>(ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                cms.getExternalAccess(root).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

                    public void customResultAvailable(IExternalAccess exta) {
                        SServiceProvider.getService((IExternalAccess)exta, IClockService.class, (String)"platform").addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IClockService, TestReport>(ret){

                            public void customResultAvailable(final IClockService clock) {
                                ResourceIdentifier rid = new ResourceIdentifier((ILocalResourceIdentifier)new LocalResourceIdentifier(root, InvokerAgent.this.agent.getModel().getResourceIdentifier().getLocalIdentifier().getUri()), null);
                                final boolean local = root.equals(InvokerAgent.this.agent.getComponentIdentifier().getRoot());
                                CreationInfo ci = new CreationInfo(local ? InvokerAgent.this.agent.getComponentIdentifier() : root, (IResourceIdentifier)rid);
                                cms.createComponent(null, "jadex/micro/testcases/intermediate/IntermediateResultProviderAgent.class", ci, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

                                    public void customResultAvailable(final IComponentIdentifier cid) {
                                        SServiceProvider.getService((IInternalAccess)InvokerAgent.this.agent, (IComponentIdentifier)cid, IIntermediateResultService.class).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IIntermediateResultService, TestReport>(ret){

                                            public void customResultAvailable(IIntermediateResultService service) {
                                                final Long[] start = new Long[1];
                                                IIntermediateFuture<String> fut = service.getResults(delay, max);
                                                fut.addResultListener((IResultListener)((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<String>(){

                                                    public void intermediateResultAvailable(String result) {
                                                        if (start[0] == null) {
                                                            start[0] = local ? clock.getTime() : System.currentTimeMillis();
                                                        }
                                                    }

                                                    public void finished() {
                                                        long needed = (local ? clock.getTime() : System.currentTimeMillis()) - start[0];
                                                        TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                                                        long expected = delay * (long)(max - 1);
                                                        if ((double)needed * 1.1 >= (double)expected) {
                                                            tr.setSucceeded(true);
                                                        } else {
                                                            tr.setReason("Results did arrive too fast (in bunch at the end (needed/expected): (" + needed + " / " + expected);
                                                        }
                                                        cms.destroyComponent(cid);
                                                        ret.setResult((Object)tr);
                                                    }

                                                    public void resultAvailable(Collection<String> result) {
                                                        System.out.println("resultAvailable: " + result);
                                                        TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                                                        tr.setReason("resultAvailable was called");
                                                        cms.destroyComponent(cid);
                                                        ret.setResult((Object)tr);
                                                    }

                                                    public void exceptionOccurred(Exception exception) {
                                                        System.out.println("exceptionOccurred: " + exception);
                                                        TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                                                        tr.setFailed(exception);
                                                        ret.setResult((Object)tr);
                                                    }
                                                }));
                                            }
                                        }));
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
        return res;
    }
}

