/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.longcall;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.ServiceCall;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.annotation.NameValue;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.IntermediateDelegationResultListener;
import jadex.commons.future.IntermediateExceptionDelegationResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Properties;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.longcall.ITestService;
import jadex.micro.testcases.longcall.ProviderAgent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global"))})
@Properties(value={@NameValue(name="test.timeout", value="jadex.base.Starter.getScaledLocalDefaultTimeout(null, 10)")})
public class InitiatorAgent
extends TestAgent {
    @Override
    protected int getTestCount() {
        return SReflect.isAndroid() ? 6 : 12;
    }

    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener((IResultListener)((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IntermediateExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(Collection<TestReport> result) {
                for (TestReport tr : result) {
                    tc.addReport(tr);
                }
                this.proceed();
            }

            public void finished() {
                this.proceed();
            }

            public void intermediateResultAvailable(TestReport result) {
                tc.addReport(result);
            }

            public void proceed() {
                if (SReflect.isAndroid()) {
                    ret.setResult(null);
                } else {
                    InitiatorAgent.this.testRemote(3).addResultListener((IResultListener)((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IntermediateExceptionDelegationResultListener<TestReport, Void>(ret){

                        public void customResultAvailable(Collection<TestReport> result) {
                            for (TestReport tr : result) {
                                tc.addReport(tr);
                            }
                            ret.setResult(null);
                        }

                        public void finished() {
                            ret.setResult(null);
                        }

                        public void intermediateResultAvailable(TestReport result) {
                            tc.addReport(result);
                        }
                    }));
                }
            }
        }));
        return ret;
    }

    protected IIntermediateFuture<TestReport> testLocal(int testno) {
        IntermediateFuture ret = new IntermediateFuture();
        this.performTests(this.agent.getComponentIdentifier().getRoot(), testno, true).addResultListener((IResultListener)((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IntermediateDelegationResultListener(ret)));
        return ret;
    }

    protected IIntermediateFuture<TestReport> testRemote(final int testno) {
        final IntermediateFuture ret = new IntermediateFuture();
        this.createPlatform(null).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Collection<TestReport>>((Future)ret){

            public void customResultAvailable(IExternalAccess platform) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, Collection<TestReport>>((Future)ret){

                    public void customResultAvailable(ITransportComponentIdentifier result) {
                        InitiatorAgent.this.performTests((IComponentIdentifier)result, testno, false).addResultListener((IResultListener)((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IntermediateDelegationResultListener(ret)));
                    }
                });
            }
        }));
        return ret;
    }

    protected IIntermediateFuture<TestReport> performTests(IComponentIdentifier root, final int testno, boolean hassectrans) {
        final IntermediateFuture ret = new IntermediateFuture();
        IntermediateFuture res = new IntermediateFuture();
        ret.addResultListener((IResultListener)new IntermediateDelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if a long running call works.");
                tr.setFailed(exception);
                ArrayList li = new ArrayList();
                super.resultAvailable(li);
            }
        });
        Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent(ProviderAgent.class.getName() + ".class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Collection<TestReport>>((Future)ret){

            public void customResultAvailable(IComponentIdentifier cid) {
                InitiatorAgent.this.callServices(cid, testno, -1L).addResultListener((IResultListener)new IntermediateDelegationResultListener(ret));
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                super.exceptionOccurred(exception);
            }
        });
        return res;
    }

    protected IIntermediateFuture<TestReport> callServices(IComponentIdentifier cid, int testno, final long to) {
        final IntermediateFuture ret = new IntermediateFuture();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ITestService.class, cid);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<ITestService, Collection<TestReport>>((Future)ret){

            public void customResultAvailable(ITestService ts) {
                if (to != -1L) {
                    ServiceCall call = ServiceCall.getOrCreateNextInvocation();
                    call.setTimeout(to);
                    call.setRealtime(Boolean.TRUE);
                }
                InitiatorAgent.this.callMethod(ts, 1, (IntermediateFuture<TestReport>)ret).addResultListener((IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        ret.setFinished();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setException(exception);
                    }
                });
            }
        });
        return ret;
    }

    protected IFuture<Void> callMethod(final ITestService ts, final int cnt, final IntermediateFuture<TestReport> ret) {
        final Future res = new Future();
        try {
            System.gc();
            final TestReport tr = new TestReport("#" + cnt, "Test if long call works with normal timeout.");
            Method m = ITestService.class.getMethod("method" + cnt, new Class[0]);
            ServiceCall.getOrCreateNextInvocation().setTimeout(500L);
            final long start = System.currentTimeMillis();
            Object fut = m.invoke((Object)ts, new Object[0]);
            if (fut instanceof ISubscriptionIntermediateFuture) {
                ((ISubscriptionIntermediateFuture)fut).addResultListener((IResultListener)new IIntermediateFutureCommandResultListener<Object>(){

                    public void intermediateResultAvailable(Object result) {
                    }

                    public void finished() {
                        tr.setSucceeded(true);
                        ret.addIntermediateResult((Object)tr);
                        this.proceed();
                    }

                    public void resultAvailable(Collection<Object> result) {
                        this.finished();
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr.setFailed("Exception: " + exception);
                        ret.addIntermediateResult((Object)tr);
                        this.proceed();
                    }

                    public void commandAvailable(Object command) {
                    }

                    public void proceed() {
                        if (cnt < 6) {
                            InitiatorAgent.this.callMethod(ts, cnt + 1, (IntermediateFuture<TestReport>)ret).addResultListener((IResultListener)new DelegationResultListener(res));
                        } else {
                            res.setResult(null);
                        }
                    }
                });
            } else {
                ((IFuture)fut).addResultListener((IResultListener)new IFutureCommandResultListener<Object>(){

                    public void resultAvailable(Object result) {
                        tr.setSucceeded(true);
                        ret.addIntermediateResult((Object)tr);
                        this.proceed();
                    }

                    public void exceptionOccurred(Exception exception) {
                        System.out.println("rec exception " + cnt + ": " + (System.currentTimeMillis() - start) + ", " + System.currentTimeMillis());
                        exception.printStackTrace();
                        tr.setFailed("Exception: " + exception);
                        ret.addIntermediateResult((Object)tr);
                        this.proceed();
                    }

                    public void commandAvailable(Object command) {
                    }

                    public void proceed() {
                        if (cnt < 6) {
                            InitiatorAgent.this.callMethod(ts, cnt + 1, (IntermediateFuture<TestReport>)ret).addResultListener((IResultListener)new DelegationResultListener(res));
                        } else {
                            res.setResult(null);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return res;
    }
}

