/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.multiinvoke;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Component;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.multiinvoke.IExampleService;
import jadex.micro.testcases.multiinvoke.IMultiplexExampleService;
import java.util.ArrayList;
import java.util.Collection;

@RequiredServices(value={@RequiredService(name="ms", type=IExampleService.class, multiple=true, multiplextype=IMultiplexExampleService.class, binding=@Binding(dynamic=true))})
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Agent
@ComponentTypes(value={@ComponentType(name="provider", filename="ProviderAgent.class")})
@Configurations(value={@Configuration(name="def", components={@Component(type="provider", number="5")})})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> body() {
        final Future ret = new Future();
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("ms");
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IMultiplexExampleService, Void>(ret){

            public void customResultAvailable(IMultiplexExampleService ser) {
                int cmpcnt = 5;
                int rescnt = 5;
                int testcnt = 10;
                final ArrayList<TestReport> reports = new ArrayList<TestReport>();
                CounterResultListener endlis = new CounterResultListener(10, (IResultListener)new IResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(10, reports.toArray(new TestReport[reports.size()])));
                        ret.setResult(null);
                    }

                    public void exceptionOccurred(Exception exception) {
                        this.resultAvailable(null);
                    }
                });
                TestReport tr = new TestReport("#1a", "Test indirect intermediate future version.");
                reports.add(tr);
                ser.getItem1().addResultListener(new CustomIntermediateResultListener(tr, 5, (IResultListener<Void>)endlis));
                tr = new TestReport("#1b", "Test indirect intermediate future version.");
                reports.add(tr);
                ser.getItems1(5).addResultListener(new CustomIntermediateResultListener(tr, 5, (IResultListener<Void>)endlis));
                tr = new TestReport("#2a", "Test indirect future version.");
                reports.add(tr);
                ser.getItem2().addResultListener(new CustomResultListener(tr, 5, (IResultListener<Void>)endlis));
                tr = new TestReport("#2b", "Test indirect future version.");
                reports.add(tr);
                ser.getItems2(5).addResultListener(new CustomResultListener(tr, 5, (IResultListener<Void>)endlis));
                tr = new TestReport("#3a", "Test flattened intermediate future version.");
                reports.add(tr);
                ser.getItem3().addResultListener(new CustomIntermediateResultListener(tr, 5, (IResultListener<Void>)endlis));
                tr = new TestReport("#3b", "Test flattened intermediate future version.");
                reports.add(tr);
                ser.getItems3(5).addResultListener(new CustomIntermediateResultListener(tr, 25, (IResultListener<Void>)endlis));
                tr = new TestReport("#4a", "Test flattened future version.");
                reports.add(tr);
                ser.getItem4().addResultListener(new CustomResultListener(tr, 5, (IResultListener<Void>)endlis));
                tr = new TestReport("#4b", "Test flattened future version.");
                reports.add(tr);
                ser.getItems4(5).addResultListener(new CustomResultListener(tr, 25, (IResultListener<Void>)endlis));
                ArrayList<Object[]> tasks = new ArrayList<Object[]>();
                tasks.add(new Object[]{1, 2});
                tasks.add(new Object[]{3, 4});
                tasks.add(new Object[]{5, 6});
                tr = new TestReport("#5a", "Test sequential multuplexer.");
                reports.add(tr);
                ser.add(tasks).addResultListener(new CustomIntermediateResultListener(tr, 3, (IResultListener<Void>)endlis));
                tr = new TestReport("#5b", "Test sequential multuplexer with collector.");
                reports.add(tr);
                ser.sum(tasks).addResultListener(new CustomResultListener(tr, 1, (IResultListener<Void>)endlis));
            }
        });
        return ret;
    }

    public class CustomResultListener<T>
    implements IResultListener<T> {
        protected int cnt = 0;
        protected int rescnt;
        protected TestReport tr;
        protected IResultListener<Void> endlis;

        public CustomResultListener(TestReport tr, int rescnt, IResultListener<Void> endlis) {
            this.tr = tr;
            this.rescnt = rescnt;
            this.endlis = endlis;
        }

        public void resultAvailable(T result) {
            System.out.println("result: " + result);
            if (result instanceof Collection && ((Collection)result).size() == this.rescnt || this.rescnt == 1) {
                this.tr.setSucceeded(true);
            } else {
                this.tr.setReason("Wrong number of results: " + result);
            }
            this.endlis.resultAvailable(null);
        }

        public void exceptionOccurred(Exception exception) {
            this.tr.setFailed(exception);
            this.endlis.resultAvailable(null);
        }
    }

    public class CustomIntermediateResultListener<T>
    implements IIntermediateResultListener<T> {
        protected int cnt = 0;
        protected int rescnt;
        protected TestReport tr;
        protected IResultListener<Void> endlis;

        public CustomIntermediateResultListener(TestReport tr, int rescnt, IResultListener<Void> endlis) {
            this.tr = tr;
            this.rescnt = rescnt;
            this.endlis = endlis;
        }

        public void intermediateResultAvailable(T result) {
            System.out.println("result: " + result);
            ++this.cnt;
        }

        public void finished() {
            if (this.cnt == this.rescnt) {
                this.tr.setSucceeded(true);
            } else {
                this.tr.setReason("Wrong number of results: " + this.cnt);
            }
            this.endlis.resultAvailable(null);
        }

        public void resultAvailable(Collection<T> result) {
            if (result.size() == this.rescnt) {
                this.tr.setSucceeded(true);
            } else {
                this.tr.setReason("Wrong number of results: " + result.size());
            }
            this.endlis.resultAvailable(null);
        }

        public void exceptionOccurred(Exception exception) {
            this.tr.setFailed(exception);
            this.endlis.resultAvailable(null);
        }
    }
}

