/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.nfcallreturn;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.ServiceCall;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.nfcallreturn.ITestService;
import jadex.micro.testcases.nfcallreturn.ProviderAgent;
import java.util.Collection;

@Agent
@RequiredServices(value={@RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global"))})
public class InitiatorAgent
extends TestAgent {
    @Override
    protected int getTestCount() {
        return 4;
    }

    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport[], Void>(ret){

            public void customResultAvailable(TestReport[] result) {
                for (TestReport tr : result) {
                    tc.addReport(tr);
                }
                InitiatorAgent.this.testRemote(3).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport[], Void>(ret){

                    public void customResultAvailable(TestReport[] result) {
                        for (TestReport tr : result) {
                            tc.addReport(tr);
                        }
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport[]> testLocal(int testno) {
        Future ret = new Future();
        this.performTests(this.agent.getComponentIdentifier().getRoot(), testno, true).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
        return ret;
    }

    protected IFuture<TestReport[]> testRemote(final int testno) {
        final Future ret = new Future();
        this.createPlatform(null).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport[]>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport[]>(ret){

                    public void customResultAvailable(ITransportComponentIdentifier result) {
                        InitiatorAgent.this.performTests((IComponentIdentifier)result, testno, false).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                    }
                });
            }
        }));
        return ret;
    }

    protected IFuture<TestReport[]> performTests(IComponentIdentifier root, final int testno, boolean hassectrans) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport[]>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if nfcallreturn works.");
                tr.setFailed(exception);
                super.resultAvailable((Object)new TestReport[]{tr});
            }
        });
        Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent(ProviderAgent.class.getName() + ".class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport[]>(ret){

            public void customResultAvailable(final IComponentIdentifier cid) {
                InitiatorAgent.this.callReqService(cid, testno, 5000L).addResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, TestReport[]>(ret){

                    public void customResultAvailable(final TestReport result1) {
                        InitiatorAgent.this.callProService(cid, testno + 1, 5000L).addResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, TestReport[]>(ret){

                            public void customResultAvailable(TestReport result2) {
                                ret.setResult((Object)new TestReport[]{result1, result2});
                            }
                        });
                    }
                });
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                super.exceptionOccurred(exception);
            }
        });
        return res;
    }

    protected IFuture<TestReport> callReqService(IComponentIdentifier cid, int testno, long to) {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Test if returning changed nf props works with required proxy");
        IFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(ITestService.class, cid);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<ITestService, TestReport>(ret){

            public void customResultAvailable(ITestService ts) {
                InitiatorAgent.this.callService(ts, tr).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return ret;
    }

    protected IFuture<TestReport> callProService(IComponentIdentifier cid, int testno, long to) {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Test if returning changed nf props works with provided proxy");
        IFuture fut = SServiceProvider.getService((IInternalAccess)this.agent, (IComponentIdentifier)cid, ITestService.class, (boolean)false);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<ITestService, TestReport>(ret){

            public void customResultAvailable(ITestService ts) {
                InitiatorAgent.this.callService(ts, tr).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return ret;
    }

    protected IFuture<TestReport> callService(ITestService ts, final TestReport tr) {
        final Future ret = new Future();
        ServiceCall call = ServiceCall.getOrCreateNextInvocation();
        call.setProperty("extra", (Object)"somval");
        ts.method("test1").addResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                ServiceCall sc = ServiceCall.getLastInvocation();
                if ("new".equals(sc.getProperty("new"))) {
                    tr.setSucceeded(true);
                } else {
                    tr.setFailed("Wrong service call properties: " + sc);
                }
                ret.setResult((Object)tr);
            }

            public void exceptionOccurred(Exception exception) {
                tr.setFailed("Failed with exception: " + exception);
                ret.setResult((Object)tr);
            }
        });
        return ret;
    }
}

