/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.nflatency;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.SNFPropertyProvider;
import jadex.bridge.nonfunctional.annotation.NFRProperty;
import jadex.bridge.sensor.service.LatencyProperty;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.MethodInfo;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.future.DefaultTuple2ResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.future.TupleResult;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.testcases.TestAgent;
import jadex.micro.testcases.nflatency.ITestService;
import jadex.micro.testcases.nflatency.ProviderAgent;
import java.util.Collection;
import java.util.Map;

@Agent
@RequiredServices(value={@RequiredService(name="cms", type=IComponentManagementService.class, binding=@Binding(scope="platform")), @RequiredService(name="ts", type=ITestService.class, binding=@Binding(scope="global")), @RequiredService(name="aser", type=ITestService.class, multiple=true, binding=@Binding(scope="global", dynamic=true), nfprops={@NFRProperty(value=LatencyProperty.class, methodname="methodA", methodparametertypes={long.class})})})
public class InitiatorAgent
extends TestAgent {
    @Override
    protected IFuture<Void> performTests(final Testcase tc) {
        final Future ret = new Future();
        this.testLocal(1).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                InitiatorAgent.this.testRemote(2).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, Void>(ret){

                    public void customResultAvailable(TestReport result) {
                        tc.addReport(result);
                        ret.setResult(null);
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testLocal(int testno) {
        final Future ret = new Future();
        this.performTest(this.agent.getComponentIdentifier().getRoot(), testno, true).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

            public void customResultAvailable(TestReport result) {
                ret.setResult((Object)result);
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> testRemote(final int testno) {
        final Future ret = new Future();
        this.createPlatform(null).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

            public void customResultAvailable(IExternalAccess platform) {
                ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport>(ret){

                    public void customResultAvailable(final ITransportComponentIdentifier result) {
                        IFuture fut = ((IRequiredServicesFeature)InitiatorAgent.this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("cms");
                        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, TestReport>(ret){

                            public void customResultAvailable(IComponentManagementService cms) {
                                CreationInfo ci = new CreationInfo(SUtil.createHashMap((Object[])new String[]{"component"}, (Object[])new Object[]{result.getRoot()}));
                                cms.createComponent("jadex.platform.service.remote.ProxyAgent.class", ci).addResultListener((IResultListener)new Tuple2Listener<IComponentIdentifier, Map<String, Object>>(){

                                    public void firstResultAvailable(IComponentIdentifier result) {
                                        InitiatorAgent.this.performTest(result, testno, false).addResultListener(((IExecutionFeature)InitiatorAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                                    }

                                    public void secondResultAvailable(Map<String, Object> result) {
                                        System.out.println("sec");
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        ret.setExceptionIfUndone(exception);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        }));
        return ret;
    }

    protected IFuture<TestReport> performTest(IComponentIdentifier root, final int testno, boolean hassectrans) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if nflatency works.");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        Future resfut = new Future();
        DelegationResultListener reslis = new DelegationResultListener(resfut);
        this.createComponent(ProviderAgent.class.getName() + ".class", root, (IResultListener<Collection<Tuple2<String, Object>>>)reslis).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

            public void customResultAvailable(IComponentIdentifier cid) {
                InitiatorAgent.this.callService(cid, testno, 5000L).addResultListener((IResultListener)new DelegationResultListener(ret));
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
                super.exceptionOccurred(exception);
            }
        });
        return res;
    }

    protected IFuture<TestReport> callService(final IComponentIdentifier cid, int testno, long to) {
        final Future ret = new Future();
        final TestReport tr = new TestReport("#" + testno, "Test if returning changed nf props works");
        ITerminableIntermediateFuture fut = ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices("aser");
        fut.addResultListener((IResultListener)new IIntermediateResultListener<ITestService>(){
            boolean called;

            public void intermediateResultAvailable(ITestService result) {
                if (cid.equals(((IService)result).getServiceIdentifier().getProviderId())) {
                    this.called = true;
                    this.callService(result);
                }
            }

            public void finished() {
                if (!this.called) {
                    tr.setFailed("Service not found");
                    ret.setResult((Object)tr);
                }
            }

            public void resultAvailable(Collection<ITestService> result) {
                for (ITestService ts : result) {
                    this.intermediateResultAvailable(ts);
                }
                this.finished();
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }

            protected void callService(final ITestService ts) {
                ts.methodA(100L).addResultListener((IResultListener)new IFutureCommandResultListener<Void>(){

                    public void resultAvailable(Void result) {
                        try {
                            MethodInfo mi = new MethodInfo(ITestService.class.getMethod("methodA", Long.TYPE));
                            System.out.println("service: " + ts);
                            Long lat = (Long)SNFPropertyProvider.getRequiredMethodNFPropertyValue((IExternalAccess)InitiatorAgent.this.agent.getExternalAccess(), (IServiceIdentifier)((IService)ts).getServiceIdentifier(), (MethodInfo)mi, (String)"latency").get();
                            System.out.println("latency: " + lat);
                            tr.setSucceeded(true);
                            ret.setResult((Object)tr);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ret.setExceptionIfUndone(e);
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        tr.setFailed("Failed with exception: " + exception);
                        ret.setResult((Object)tr);
                    }

                    public void commandAvailable(Object command) {
                    }
                });
            }
        });
        return ret;
    }

    abstract class Tuple2Listener<T, E>
    extends DefaultTuple2ResultListener<T, E>
    implements IFutureCommandResultListener<Collection<TupleResult>> {
        Tuple2Listener() {
        }

        public void commandAvailable(Object command) {
        }
    }
}

