/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.nfmethodprop;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.nonfunctional.SNFPropertyProvider;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.CreationInfo;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.nfmethodprop.ITestService;
import java.lang.reflect.Method;
import java.util.ArrayList;

@Agent
@Service
@RequiredServices(value={@RequiredService(name="testser", type=ITestService.class, binding=@Binding(create=true, creationinfo=@CreationInfo(type="provider")))})
@ComponentTypes(value={@ComponentType(name="provider", filename="jadex.micro.testcases.nfmethodprop.ProviderAgent.class")})
@Results(value={@Result(name="testresults", description="The test results.", clazz=Testcase.class)})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        ITestService ser = (ITestService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("testser").get();
        ArrayList<TestReport> results = new ArrayList<TestReport>();
        long wa = SReflect.isAndroid() ? 5000L : 500L;
        long wb = SReflect.isAndroid() ? 10000L : 1000L;
        for (int i = 0; i < 5; ++i) {
            ser.methodA(wa).get();
            ser.methodB(wb).get();
        }
        try {
            TestReport tr1 = new TestReport("#1", "Test if wait time of method a is ok");
            results.add(tr1);
            Method ma = ser.getClass().getMethod("methodA", Long.TYPE);
            double w = ((Long)SNFPropertyProvider.getMethodNFPropertyValue((IExternalAccess)this.agent.getExternalAccess(), (IServiceIdentifier)((IService)ser).getServiceIdentifier(), (MethodInfo)new MethodInfo(ma), (String)"waiting time").get()).doubleValue();
            double d = Math.abs(w - (double)wa) / (double)wa;
            if (d < 0.15) {
                tr1.setSucceeded(true);
            } else {
                tr1.setReason("Value differs more than 15 percent: " + d + " " + w + " " + wa);
            }
            TestReport tr2 = new TestReport("#2", "Test if wait time of method b is ok");
            results.add(tr2);
            Method mb = ser.getClass().getMethod("methodB", Long.TYPE);
            w = ((Long)SNFPropertyProvider.getMethodNFPropertyValue((IExternalAccess)this.agent.getExternalAccess(), (IServiceIdentifier)((IService)ser).getServiceIdentifier(), (MethodInfo)new MethodInfo(mb), (String)"waiting time").get()).doubleValue();
            d = Math.abs(w - (double)wb) / (double)wb;
            if (d < 0.15) {
                tr2.setSucceeded(true);
            } else {
                tr2.setReason("Value differs more than 15 percent: " + d + " " + w + " " + wb);
            }
            TestReport tr3 = new TestReport("#3", "Test if wait time of service is ok");
            results.add(tr3);
            w = ((Long)SNFPropertyProvider.getNFPropertyValue((IExternalAccess)this.agent.getExternalAccess(), (IServiceIdentifier)((IService)ser).getServiceIdentifier(), (String)"waiting time").get()).doubleValue();
            long wab = (wa + wb) / 2L;
            d = Math.abs(w - (double)wab) / (double)wab;
            if (d < 0.15) {
                tr3.setSucceeded(true);
            } else {
                tr3.setReason("Value differs more than 15 percent: " + d + " " + w + " " + wab);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(results.size(), results.toArray(new TestReport[results.size()])));
        this.agent.killComponent();
    }
}

