/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.nfproperties;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.nonfunctional.annotation.NFProperties;
import jadex.bridge.nonfunctional.annotation.NFProperty;
import jadex.bridge.nonfunctional.search.BasicEvaluator;
import jadex.bridge.nonfunctional.search.ComposedEvaluator;
import jadex.bridge.nonfunctional.search.CountThresholdSearchTerminationDecider;
import jadex.bridge.nonfunctional.search.IRankingSearchTerminationDecider;
import jadex.bridge.nonfunctional.search.IServiceEvaluator;
import jadex.bridge.nonfunctional.search.IServiceRanker;
import jadex.bridge.sensor.unit.MemoryUnit;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.search.SServiceProvider;
import jadex.commons.Tuple2;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.testcases.nfproperties.FakeCpuLoadProperty;
import jadex.micro.testcases.nfproperties.FakeFreeMemoryProperty;
import jadex.micro.testcases.nfproperties.FakeNetworkBandwidthProperty;
import jadex.micro.testcases.nfproperties.FakeReliabilityProperty;
import jadex.micro.testcases.nfproperties.ICoreDependentService;
import jadex.micro.testcases.nfproperties.NFPropertyTestService;
import java.util.Arrays;
import java.util.Collection;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=ICoreDependentService.class, implementation=@Implementation(value=NFPropertyTestService.class))})
@NFProperties(value={@NFProperty(value=FakeCpuLoadProperty.class), @NFProperty(value=FakeFreeMemoryProperty.class), @NFProperty(value=FakeNetworkBandwidthProperty.class), @NFProperty(value=FakeReliabilityProperty.class)})
public class ServiceSearchAgent {
    protected static final int SEARCH_DELAY = 1000;
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> body() {
        Future done = new Future();
        final ComposedEvaluator ce = new ComposedEvaluator();
        ce.addEvaluator((IServiceEvaluator)new BasicEvaluator<Double>(this.agent.getExternalAccess(), "fakecpuload"){

            public double calculateEvaluation(Double propertyvalue) {
                return (100.0 - propertyvalue) * 0.01;
            }
        });
        ce.addEvaluator((IServiceEvaluator)new BasicEvaluator<Double>(this.agent.getExternalAccess(), "fakereliability"){

            public double calculateEvaluation(Double propertyvalue) {
                return propertyvalue * 0.01;
            }
        });
        ce.addEvaluator((IServiceEvaluator)new BasicEvaluator<Long>(this.agent.getExternalAccess(), "fakefreemem", (Object)MemoryUnit.MB){

            public double calculateEvaluation(Long propertyvalue) {
                return Math.min(4096.0, (double)propertyvalue.longValue()) / 4096.0;
            }
        });
        ce.addEvaluator((IServiceEvaluator)new BasicEvaluator<Long>(this.agent.getExternalAccess(), "fakenetworkbandwith", (Object)MemoryUnit.MB){

            public double calculateEvaluation(Long propertyvalue) {
                return Math.min(100.0, (double)propertyvalue.longValue()) / 100.0;
            }
        });
        ((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, (IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                final 5 step = this;
                ITerminableIntermediateFuture fut = SServiceProvider.getServices((IInternalAccess)ServiceSearchAgent.this.agent, ICoreDependentService.class, (String)"platform");
                ITerminableIntermediateFuture res = SServiceProvider.rankServicesWithScores((ITerminableIntermediateFuture)fut, (IServiceRanker)ce, (IRankingSearchTerminationDecider)new CountThresholdSearchTerminationDecider(10));
                res.addResultListener((IResultListener)new IResultListener<Collection<Tuple2<ICoreDependentService, Double>>>(){

                    public void resultAvailable(Collection<Tuple2<ICoreDependentService, Double>> result) {
                        System.out.println(Arrays.toString(result.toArray()));
                        ((IExecutionFeature)ServiceSearchAgent.this.agent.getComponentFeature(IExecutionFeature.class)).waitForDelay(1000L, step);
                    }

                    public void exceptionOccurred(Exception exception) {
                        exception.printStackTrace();
                    }
                });
                return IFuture.DONE;
            }
        });
        return done;
    }
}

