/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.nfservicetags;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.CreationInfo;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.nfservicetags.ITestService;
import java.util.ArrayList;
import java.util.Collection;

@Agent
@Service
@RequiredServices(value={@RequiredService(name="testser1", type=ITestService.class, binding=@Binding(create=true, creationinfo=@CreationInfo(type="provider"))), @RequiredService(name="testser2", type=ITestService.class, tags={"\"platform_name\""}), @RequiredService(name="testser3", type=ITestService.class, tags={"blatag"})})
@ComponentTypes(value={@ComponentType(name="provider", filename="jadex.micro.testcases.nfservicetags.ProviderAgent.class")})
@Results(value={@Result(name="testresults", description="The test results.", clazz=Testcase.class)})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        ArrayList<TestReport> results = new ArrayList<TestReport>();
        TestReport tr1 = new TestReport("#1", "Test if can find service withouts tags.");
        try {
            ITestService ser = (ITestService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("testser1").get();
            tr1.setSucceeded(true);
        }
        catch (Exception e) {
            tr1.setReason("Exception occurred: " + e);
        }
        results.add(tr1);
        TestReport tr2 = new TestReport("#2", "Test if can find service with tags in required service defition.");
        try {
            ITestService ser = (ITestService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("testser2").get();
            tr2.setSucceeded(true);
        }
        catch (Exception e) {
            tr2.setReason("Exception occurred: " + e);
        }
        results.add(tr2);
        TestReport tr3 = new TestReport("#3", "Test if can find service with tags in required service defition that are not defined on service.");
        try {
            ITestService ser = (ITestService)((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService("testser3").get();
            tr3.setReason("Found service that does not have the tag");
        }
        catch (Exception e) {
            tr3.setSucceeded(true);
        }
        results.add(tr3);
        TestReport tr4 = new TestReport("#4", "Test if can find service via SServiceProvider.getServices()");
        try {
            Collection sers = (Collection)SServiceProvider.getTaggedServices((IInternalAccess)this.agent, ITestService.class, (String)"platform", (String[])new String[]{"\"platform_name\""}).get();
            tr4.setSucceeded(true);
        }
        catch (Exception e) {
            tr4.setReason("Exception occurred: " + e);
        }
        results.add(tr4);
        TestReport tr5 = new TestReport("#5", "Test if can find service via SServiceProvider.getService()");
        try {
            ITestService ser = (ITestService)SServiceProvider.getTaggedService((IInternalAccess)this.agent, ITestService.class, (String)"platform", (String[])new String[]{"\"platform_name\""}).get();
            tr5.setSucceeded(true);
        }
        catch (Exception e) {
            tr5.setReason("Exception occurred: " + e);
        }
        results.add(tr5);
        ((IArgumentsResultsFeature)this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(results.size(), results.toArray(new TestReport[results.size()])));
        this.agent.killComponent();
    }
}

