/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.prepostconditions;

import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IProvidedServicesFeature;
import jadex.commons.SReflect;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateFuture;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.prepostconditions.IContractService;
import java.util.ArrayList;
import java.util.List;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=IContractService.class, implementation=@Implementation(expression="$pojoagent"))})
@Results(value={@Result(name="testresults", description="The test results.", clazz=Testcase.class)})
public class ConditionAgent
implements IContractService {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public IFuture<Void> body() {
        final Future ret = new Future();
        final ArrayList<TestReport> results = new ArrayList<TestReport>();
        IContractService ts = ((IContractService[])((IProvidedServicesFeature)this.agent.getComponentFeature(IProvidedServicesFeature.class)).getProvidedServices(IContractService.class))[0];
        CounterResultListener lis = new CounterResultListener(12, (IResultListener)new DefaultResultListener<Void>(){

            public void resultAvailable(Void result) {
                ((IArgumentsResultsFeature)ConditionAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", new Testcase(results.size(), results.toArray(new TestReport[results.size()])));
                ret.setResult(null);
            }
        });
        TestReport tr = new TestReport("#1", "Normal call.");
        results.add(tr);
        ts.doSomething("hi", 6, 2).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)null, (IResultListener<?>)lis));
        tr = new TestReport("#2", "Test if null argument is detected");
        results.add(tr);
        ts.doSomething(null, 6, 2).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IllegalArgumentException.class, (IResultListener<?>)lis));
        tr = new TestReport("#3", "Test if arg>0 is detected");
        results.add(tr);
        ts.doSomething("hi", 6, -1).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IllegalStateException.class, (IResultListener<?>)lis));
        tr = new TestReport("#4", "Test if null result is detected.");
        results.add(tr);
        ts.doSomething("null", 1, 1).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IllegalArgumentException.class, (IResultListener<?>)lis));
        tr = new TestReport("#5", "Test if result <100 is detected.");
        results.add(tr);
        ts.doSomething("hi", 1000, 1).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IllegalStateException.class, (IResultListener<?>)lis));
        ArrayList<String> names = new ArrayList<String>();
        names.add("Alfons");
        names.add("Berta");
        names.add("Charlie");
        tr = new TestReport("#6", "Normal call.");
        results.add(tr);
        ts.getName(0, names).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)null, (IResultListener<?>)lis));
        tr = new TestReport("#7", "Normal call.");
        results.add(tr);
        ts.getName(1, names).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)null, (IResultListener<?>)lis));
        tr = new TestReport("#8", "Normal call.");
        results.add(tr);
        ts.getName(2, names).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)null, (IResultListener<?>)lis));
        tr = new TestReport("#9", "Test if index<0 is detected.");
        results.add(tr);
        ts.getName(-1, names).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IndexOutOfBoundsException.class, (IResultListener<?>)lis));
        tr = new TestReport("#10", "Test if index>size is detected.");
        results.add(tr);
        ts.getName(3, names).addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IndexOutOfBoundsException.class, (IResultListener<?>)lis));
        tr = new TestReport("#11", "Test if intermediate result checks work with keep.");
        results.add(tr);
        ts.getIncreasingValue().addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IllegalStateException.class, (IResultListener<?>)lis));
        tr = new TestReport("#12", "Test if intermediate result checks work without keep.");
        results.add(tr);
        ts.getIncreasingValue2().addResultListener(new DetectionListener(tr, (Class<RuntimeException>)IllegalStateException.class, (IResultListener<?>)lis));
        return ret;
    }

    @Override
    public IFuture<Integer> doSomething(String a, int x, int y) {
        return "null".equals(a) ? new Future(null) : new Future((Object)(x / y));
    }

    @Override
    public IFuture<String> getName(int idx, List<String> names) {
        return new Future((Object)names.get(idx));
    }

    @Override
    public IIntermediateFuture<Integer> getIncreasingValue() {
        IntermediateFuture ret = new IntermediateFuture();
        ret.addIntermediateResult((Object)1);
        ret.addIntermediateResult((Object)2);
        ret.addIntermediateResult((Object)3);
        ret.addIntermediateResult((Object)4);
        ret.addIntermediateResult((Object)0);
        return ret;
    }

    @Override
    public IIntermediateFuture<Integer> getIncreasingValue2() {
        return this.getIncreasingValue();
    }

    public static class DetectionListener<E>
    implements IResultListener<E> {
        protected TestReport tr;
        protected Class<? extends RuntimeException> expected;
        protected IResultListener<?> delegate;

        public DetectionListener(TestReport tr, Class<? extends RuntimeException> expected, IResultListener<?> delegate) {
            this.tr = tr;
            this.expected = expected;
            this.delegate = delegate;
        }

        public void resultAvailable(Object result) {
            if (this.expected == null) {
                this.tr.setSucceeded(true);
            } else {
                this.tr.setFailed("Expected exception: " + this.expected + " but no exception was thrown.");
            }
            this.delegate.resultAvailable(null);
        }

        public void exceptionOccurred(Exception exception) {
            if (this.expected == null) {
                this.tr.setFailed("No exception expected, but exception was thrown: " + exception);
            } else if (SReflect.isSupertype(this.expected, exception.getClass())) {
                this.tr.setSucceeded(true);
            } else {
                this.tr.setFailed("Wrong exception type received: " + exception);
            }
            this.delegate.resultAvailable(null);
        }
    }
}

