/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.pull;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ILocalResourceIdentifier;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.LocalResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IPullIntermediateFuture;
import jadex.commons.future.IPullSubscriptionIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.pull.IPullResultService;
import jadex.micro.testcases.pull.PullResultProviderAgent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Agent
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@Description(value="The invoker agent tests if pull results are directly delivered back to the invoker in local and remote case.")
public class InvokerAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        final Testcase tc = new Testcase();
        if (SReflect.isAndroid()) {
            tc.setTestCount(2);
        } else {
            tc.setTestCount(4);
        }
        final Future ret = new Future();
        ret.addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                ((IArgumentsResultsFeature)InvokerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                InvokerAgent.this.agent.killComponent();
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).isComponentThread() + " " + InvokerAgent.this.agent.getComponentIdentifier());
                ((IArgumentsResultsFeature)InvokerAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                InvokerAgent.this.agent.killComponent();
            }
        }));
        this.testLocal(1, 100L, 3).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport[], Void>(ret){

            public void customResultAvailable(TestReport[] result) {
                for (TestReport tr : result) {
                    tc.addReport(tr);
                }
                if (SReflect.isAndroid()) {
                    ret.setResult(null);
                } else {
                    InvokerAgent.this.testRemote(2, 100L, 3).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport[], Void>(ret){

                        public void customResultAvailable(TestReport[] result) {
                            for (TestReport tr : result) {
                                tc.addReport(tr);
                            }
                            ret.setResult(null);
                        }
                    }));
                }
            }
        }));
    }

    protected IFuture<TestReport[]> testLocal(final int testno, final long delay, final int max) {
        final Future ret = new Future();
        this.performTestA(this.agent.getComponentIdentifier().getRoot(), testno, delay, max).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, TestReport[]>(ret){

            public void customResultAvailable(final TestReport result1) {
                InvokerAgent.this.performTestB(InvokerAgent.this.agent.getComponentIdentifier().getRoot(), testno + 1, delay, max).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, TestReport[]>(ret){

                    public void customResultAvailable(TestReport result2) {
                        ret.setResult((Object)new TestReport[]{result1, result2});
                    }
                }));
            }
        }));
        return ret;
    }

    protected IFuture<TestReport[]> testRemote(final int testno, final long delay, final int max) {
        final Future ret = new Future();
        try {
            String url = SUtil.getOutputDirsExpression((String)"../jadex-applications-micro");
            Starter.createPlatform((String[])new String[]{"-libpath", url, "-platformname", this.agent.getComponentIdentifier().getPlatformPrefix() + "_*", "-saveonexit", "false", "-welcome", "false", "-autoshutdown", "false", "-awareness", "false", "-gui", "false", "-simulation", "false", "-printpass", "false"}).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport[]>(ret){

                public void customResultAvailable(final IExternalAccess platform) {
                    ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport[]>(ret){

                        public void customResultAvailable(final ITransportComponentIdentifier result) {
                            InvokerAgent.this.performTestA((IComponentIdentifier)result, testno, delay, max).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, TestReport[]>(ret){

                                public void customResultAvailable(final TestReport result1) {
                                    InvokerAgent.this.performTestB((IComponentIdentifier)result, testno + 1, delay, max).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<TestReport, TestReport[]>(ret){

                                        public void customResultAvailable(TestReport result2) {
                                            platform.killComponent();
                                            ret.setResult((Object)new TestReport[]{result1, result2});
                                        }
                                    }));
                                }
                            }));
                        }
                    });
                }
            }));
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }

    protected IFuture<TestReport> performTestA(final IComponentIdentifier root, final int testno, long delay, final int max) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, TestReport>(ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                cms.getExternalAccess(root).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

                    public void customResultAvailable(IExternalAccess exta) {
                        SServiceProvider.getService((IExternalAccess)exta, IClockService.class, (String)"platform").addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IClockService, TestReport>(ret){

                            public void customResultAvailable(IClockService clock) {
                                ResourceIdentifier rid = new ResourceIdentifier((ILocalResourceIdentifier)new LocalResourceIdentifier(root, InvokerAgent.this.agent.getModel().getResourceIdentifier().getLocalIdentifier().getUri()), null);
                                boolean local = root.equals(InvokerAgent.this.agent.getComponentIdentifier().getRoot());
                                CreationInfo ci = new CreationInfo(local ? InvokerAgent.this.agent.getComponentIdentifier() : root, (IResourceIdentifier)rid);
                                cms.createComponent(null, PullResultProviderAgent.class.getName() + ".class", ci, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

                                    public void customResultAvailable(IComponentIdentifier cid) {
                                        SServiceProvider.getService((IInternalAccess)InvokerAgent.this.agent, (IComponentIdentifier)cid, IPullResultService.class).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IPullResultService, TestReport>(ret){

                                            public void customResultAvailable(IPullResultService service) {
                                                IPullIntermediateFuture<String> fut = service.getResultsA(max);
                                                fut.addResultListener((IResultListener)((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<String>(){
                                                    protected List<String> res = new ArrayList<String>();

                                                    public void intermediateResultAvailable(String result) {
                                                        System.out.println("intermediateResultAvailable: " + result);
                                                        this.res.add(result);
                                                    }

                                                    public void finished() {
                                                        TestReport tr = new TestReport("#" + testno, "Tests if pull results work");
                                                        if (this.res.size() == max) {
                                                            tr.setSucceeded(true);
                                                        } else {
                                                            tr.setReason("Not all results did arrive: (" + this.res.size() + " / " + max);
                                                        }
                                                        ret.setResult((Object)tr);
                                                    }

                                                    public void resultAvailable(Collection<String> result) {
                                                        System.out.println("resultAvailable: " + result);
                                                        TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                                                        tr.setReason("resultAvailable was called");
                                                        ret.setResult((Object)tr);
                                                    }

                                                    public void exceptionOccurred(Exception exception) {
                                                        System.out.println("exceptionOccurred: " + exception);
                                                        TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                                                        tr.setFailed(exception);
                                                        ret.setResult((Object)tr);
                                                    }
                                                }));
                                                for (int i = 0; i < max; ++i) {
                                                    fut.pullIntermediateResult();
                                                }
                                            }
                                        }));
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
        return res;
    }

    protected IFuture<TestReport> performTestB(final IComponentIdentifier root, final int testno, long delay, final int max) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if intermediate results work");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, TestReport>(ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                cms.getExternalAccess(root).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

                    public void customResultAvailable(IExternalAccess exta) {
                        SServiceProvider.getService((IExternalAccess)exta, IClockService.class, (String)"platform").addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IClockService, TestReport>(ret){

                            public void customResultAvailable(IClockService clock) {
                                ResourceIdentifier rid = new ResourceIdentifier((ILocalResourceIdentifier)new LocalResourceIdentifier(root, InvokerAgent.this.agent.getModel().getResourceIdentifier().getLocalIdentifier().getUri()), null);
                                boolean local = root.equals(InvokerAgent.this.agent.getComponentIdentifier().getRoot());
                                CreationInfo ci = new CreationInfo(local ? InvokerAgent.this.agent.getComponentIdentifier() : root, (IResourceIdentifier)rid);
                                cms.createComponent(null, PullResultProviderAgent.class.getName() + ".class", ci, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

                                    public void customResultAvailable(final IComponentIdentifier cid) {
                                        SServiceProvider.getService((IInternalAccess)InvokerAgent.this.agent, (IComponentIdentifier)cid, IPullResultService.class).addResultListener(((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IPullResultService, TestReport>(ret){

                                            public void customResultAvailable(IPullResultService service) {
                                                IPullSubscriptionIntermediateFuture<String> fut2 = service.getResultsB(max);
                                                fut2.addResultListener((IResultListener)((IExecutionFeature)InvokerAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateResultListener<String>(){
                                                    protected List<String> res = new ArrayList<String>();

                                                    public void intermediateResultAvailable(String result) {
                                                        System.out.println("intermediateResultAvailable: " + result);
                                                        this.res.add(result);
                                                    }

                                                    public void finished() {
                                                        TestReport tr = new TestReport("#" + testno, "Tests if pull results work");
                                                        tr.setReason("Exception did not occur");
                                                        cms.destroyComponent(cid);
                                                        ret.setResult((Object)tr);
                                                    }

                                                    public void resultAvailable(Collection<String> result) {
                                                        System.out.println("resultAvailable: " + result);
                                                        TestReport tr = new TestReport("#" + testno, "Tests if pull results work");
                                                        tr.setReason("Exception did not occur");
                                                        cms.destroyComponent(cid);
                                                        ret.setResult((Object)tr);
                                                    }

                                                    public void exceptionOccurred(Exception exception) {
                                                        System.out.println("exceptionOccurred: " + exception);
                                                        TestReport tr = new TestReport("#" + testno, "Tests if pull results work");
                                                        if (exception instanceof FutureTerminatedException) {
                                                            tr.setSucceeded(true);
                                                        } else {
                                                            tr.setReason("Other exception: (" + exception);
                                                        }
                                                        cms.destroyComponent(cid);
                                                        ret.setResult((Object)tr);
                                                    }
                                                }));
                                                fut2.pullIntermediateResult();
                                                fut2.terminate();
                                                fut2.pullIntermediateResult();
                                            }
                                        }));
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
        return res;
    }
}

