/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.pull;

import jadex.bridge.IInternalAccess;
import jadex.bridge.service.annotation.Service;
import jadex.commons.ICommand;
import jadex.commons.future.IPullIntermediateFuture;
import jadex.commons.future.IPullSubscriptionIntermediateFuture;
import jadex.commons.future.ITerminationCommand;
import jadex.commons.future.PullIntermediateFuture;
import jadex.commons.future.PullSubscriptionIntermediateFuture;
import jadex.commons.future.TerminationCommand;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.testcases.pull.IPullResultService;

@Agent
@Service
@ProvidedServices(value={@ProvidedService(type=IPullResultService.class, implementation=@Implementation(expression="$pojoagent"))})
@Description(value="Agent that provides a service with intermediate results")
public class PullResultProviderAgent
implements IPullResultService {
    @Agent
    protected IInternalAccess agent;

    @Override
    public IPullIntermediateFuture<String> getResultsA(final int max) {
        PullIntermediateFuture ret = new PullIntermediateFuture((ICommand)new ICommand<PullIntermediateFuture<String>>(){
            int cnt = 0;

            public void execute(PullIntermediateFuture<String> fut) {
                if (this.cnt < max) {
                    fut.addIntermediateResult((Object)("step(" + this.cnt++ + "/" + max + ")"));
                }
                if (this.cnt == max) {
                    fut.setFinished();
                }
            }
        });
        return ret;
    }

    @Override
    public IPullSubscriptionIntermediateFuture<String> getResultsB(final int max) {
        PullSubscriptionIntermediateFuture ret = new PullSubscriptionIntermediateFuture((ICommand)new ICommand<PullSubscriptionIntermediateFuture<String>>(){
            int cnt = 0;

            public void execute(PullSubscriptionIntermediateFuture<String> fut) {
                if (this.cnt < max) {
                    fut.addIntermediateResultIfUndone((Object)("step(" + this.cnt++ + "/" + max + ")"));
                }
                if (this.cnt == max) {
                    fut.setFinishedIfUndone();
                }
            }
        }, (ITerminationCommand)new TerminationCommand(){

            public void terminated(Exception reason) {
                System.out.println("terminated");
            }
        });
        return ret;
    }
}

