/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.testcases.recfutures;

import jadex.base.Starter;
import jadex.base.test.TestReport;
import jadex.base.test.Testcase;
import jadex.bridge.ComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ILocalResourceIdentifier;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.LocalResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.IService;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Result;
import jadex.micro.annotation.Results;
import jadex.micro.testcases.recfutures.AAgent;
import jadex.micro.testcases.recfutures.IAService;

@Agent
@Service
@Results(value={@Result(name="testresults", clazz=Testcase.class)})
@ComponentTypes(value={@ComponentType(name="aagent", clazz=AAgent.class)})
@RequiredServices(value={@RequiredService(name="aser", type=IAService.class, binding=@Binding(scope="none", create=true, creationinfo=@jadex.micro.annotation.CreationInfo(type="aagent")))})
public class UserAgent {
    @Agent
    protected IInternalAccess agent;

    @AgentBody
    public void body() {
        final Testcase tc = new Testcase();
        if (SReflect.isAndroid()) {
            System.out.println("Running on android, setting test nr to 1");
            tc.setTestCount(1);
        } else {
            tc.setTestCount(2);
        }
        final Future ret = new Future();
        ret.addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<TestReport>(){

            public void resultAvailable(TestReport result) {
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                UserAgent.this.agent.killComponent();
            }

            public void exceptionOccurred(Exception exception) {
                System.out.println(((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).isComponentThread() + " " + UserAgent.this.agent.getComponentIdentifier());
                ((IArgumentsResultsFeature)UserAgent.this.agent.getComponentFeature(IArgumentsResultsFeature.class)).getResults().put("testresults", tc);
                UserAgent.this.agent.killComponent();
            }
        }));
        this.testLocal(1, 100L, 3).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

            public void customResultAvailable(TestReport result) {
                tc.addReport(result);
                if (SReflect.isAndroid()) {
                    System.out.println("Running on android, so skipping remote tests.");
                    ret.setResult(null);
                } else {
                    UserAgent.this.testRemote(2, 100L, 3).addResultListener(((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

                        public void customResultAvailable(TestReport result) {
                            tc.addReport(result);
                            ret.setResult(null);
                        }
                    }));
                }
            }
        }));
    }

    protected IFuture<TestReport> testLocal(int testno, long delay, int max) {
        return this.performTest(this.agent.getComponentIdentifier().getRoot(), testno, delay, max);
    }

    protected IFuture<TestReport> testRemote(final int testno, final long delay, final int max) {
        final Future ret = new Future();
        try {
            String url = SUtil.getOutputDirsExpression((String)"jadex-applications-micro");
            Starter.createPlatform((String[])new String[]{"-libpath", url, "-platformname", this.agent.getComponentIdentifier().getPlatformPrefix() + "_*", "-saveonexit", "false", "-welcome", "false", "-autoshutdown", "false", "-awareness", "false", "-gui", "false", "-simulation", "false", "-printpass", "false"}).addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, TestReport>(ret){

                public void customResultAvailable(final IExternalAccess platform) {
                    ComponentIdentifier.getTransportIdentifier((IExternalAccess)platform).addResultListener((IResultListener)new ExceptionDelegationResultListener<ITransportComponentIdentifier, TestReport>(ret){

                        public void customResultAvailable(ITransportComponentIdentifier result) {
                            UserAgent.this.performTest((IComponentIdentifier)result, testno, delay, max).addResultListener(((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener<TestReport>(ret){

                                public void customResultAvailable(TestReport result) {
                                    platform.killComponent();
                                    ret.setResult((Object)result);
                                }
                            }));
                        }
                    });
                }
            }));
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }

    protected IFuture<TestReport> performTest(final IComponentIdentifier root, final int testno, long delay, int max) {
        final Future ret = new Future();
        Future res = new Future();
        ret.addResultListener((IResultListener)new DelegationResultListener<TestReport>(res){

            public void exceptionOccurred(Exception exception) {
                TestReport tr = new TestReport("#" + testno, "Tests if rec results work");
                tr.setFailed(exception);
                super.resultAvailable((Object)tr);
            }
        });
        ((IRequiredServicesFeature)this.agent.getComponentFeature(IRequiredServicesFeature.class)).searchService(IComponentManagementService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, TestReport>(ret){

            public void customResultAvailable(IComponentManagementService cms) {
                ResourceIdentifier rid = new ResourceIdentifier((ILocalResourceIdentifier)new LocalResourceIdentifier(root, UserAgent.this.agent.getModel().getResourceIdentifier().getLocalIdentifier().getUri()), null);
                boolean local = root.equals(UserAgent.this.agent.getComponentIdentifier().getRoot());
                CreationInfo ci = new CreationInfo(local ? UserAgent.this.agent.getComponentIdentifier() : root, (IResourceIdentifier)rid);
                cms.createComponent(null, AAgent.class.getName() + ".class", ci, null).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, TestReport>(ret){

                    public void customResultAvailable(IComponentIdentifier cid) {
                        SServiceProvider.getService((IInternalAccess)UserAgent.this.agent, (IComponentIdentifier)cid, IAService.class).addResultListener(((IExecutionFeature)UserAgent.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IAService, TestReport>(ret){

                            public void customResultAvailable(IAService service) {
                                System.out.println("found service: " + ((IService)service).getServiceIdentifier());
                                IFuture<IIntermediateFuture<String>> futb = service.methodB();
                                futb.addResultListener((IResultListener)new DefaultResultListener<IIntermediateFuture<String>>(){

                                    public void resultAvailable(IIntermediateFuture<String> fut2) {
                                        System.out.println("received first: " + fut2);
                                        fut2.addResultListener((IResultListener)new IntermediateDefaultResultListener<String>(){

                                            public void intermediateResultAvailable(String result) {
                                                System.out.println("received: " + result);
                                            }

                                            public void finished() {
                                                System.out.println("fini");
                                                TestReport tr = new TestReport("#" + testno, "Tests if rec results work");
                                                tr.setSucceeded(true);
                                                ret.setResult((Object)tr);
                                            }
                                        });
                                    }
                                });
                            }
                        }));
                    }
                });
            }
        });
        return res;
    }
}

